/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingMenu;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.DrawsOnLeft;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_487;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_7923;

public class ReforgingScreen
extends class_465<ReforgingMenu>
implements DrawsOnLeft {
    public static final class_2960 TEXTURE = new class_2960("zenith", "textures/gui/reforge.png");
    protected class_1799[] choices = new class_1799[3];
    protected class_1799 lastInput = class_1799.field_8037;
    protected LootRarity lastRarity = null;
    protected class_2561 title;

    public ReforgingScreen(ReforgingMenu menu, class_1661 inv, class_2561 title) {
        super((class_1703)menu, inv, title);
        this.field_25268 = 5;
        Arrays.fill(this.choices, class_1799.field_8037);
        this.title = class_2561.method_43471((String)"container.zenith.reforge");
    }

    public boolean shouldRecompute() {
        class_1799 input = ((ReforgingMenu)this.field_2797).method_7611(0).method_7677();
        LootRarity rarity = ((ReforgingMenu)this.method_17577()).getRarity();
        return !class_1799.method_31577((class_1799)input, (class_1799)this.lastInput) || this.lastRarity != rarity;
    }

    public void recomputeChoices() {
        class_1799 input = ((ReforgingMenu)this.field_2797).method_7611(0).method_7677();
        LootRarity rarity = ((ReforgingMenu)this.method_17577()).getRarity();
        if (input.method_7960() || rarity == null) {
            Arrays.fill(this.choices, class_1799.field_8037);
        } else {
            class_5819 rand = ((ReforgingMenu)this.field_2797).random;
            for (int i = 0; i < 3; ++i) {
                rand.method_43052((long)(((ReforgingMenu)this.field_2797).getSeed() ^ class_7923.field_41178.method_10221((Object)input.method_7909()).hashCode() + i));
                this.choices[i] = LootController.createLootItem(input.method_7972(), rarity, rand);
            }
        }
        this.lastInput = input.method_7972();
        this.lastRarity = rarity;
    }

    public void method_25394(class_332 gfx, int x, int y, float pPartialTick) {
        if (this.shouldRecompute()) {
            this.recomputeChoices();
        }
        this.method_25420(gfx);
        super.method_25394(gfx, x, y, pPartialTick);
        RenderSystem.disableBlend();
        this.method_2380(gfx, x, y);
        int xCenter = (this.field_22789 - this.field_2792) / 2;
        int yCenter = (this.field_22790 - this.field_2779) / 2;
        int dust = ((ReforgingMenu)this.field_2797).getDustCount();
        int mats = ((ReforgingMenu)this.field_2797).getMatCount();
        int levels = ((ReforgingMenu)this.field_2797).player.field_7520;
        for (int slot = 0; slot < 3; ++slot) {
            class_1799 choice = this.choices[slot];
            if (choice.method_7960() || ((ReforgingMenu)this.field_2797).needsReset()) continue;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            int dustCost = ((ReforgingMenu)this.field_2797).getDustCost(slot);
            int matCost = ((ReforgingMenu)this.field_2797).getMatCost(slot);
            int levelCost = ((ReforgingMenu)this.field_2797).getLevelCost(slot);
            tooltips.add(class_2561.method_43471((String)"text.zenith.reforge_cost").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}));
            tooltips.add(class_5244.field_39003);
            if (dustCost > 0) {
                tooltips.add(class_2561.method_43469((String)"%s %s", (Object[])new Object[]{dustCost, Adventure.Items.GEM_DUST.method_7864(class_1799.field_8037)}).method_27692(dust < dustCost ? class_124.field_1061 : class_124.field_1080));
            }
            if (matCost > 0) {
                tooltips.add(class_2561.method_43469((String)"%s %s", (Object[])new Object[]{matCost, ((ReforgingMenu)this.field_2797).method_7611(1).method_7677().method_7964()}).method_27692(mats < matCost ? class_124.field_1061 : class_124.field_1080));
            }
            String key = levels >= levelCost ? (levelCost == 1 ? "container.enchant.level.one" : "container.enchant.level.many") : "container.enchant.level.requirement";
            tooltips.add(class_2561.method_43469((String)key, (Object[])new Object[]{levelCost}).method_27692(levels < levelCost ? class_124.field_1061 : class_124.field_1080));
            int k2 = x - (xCenter + 60);
            int l2 = y - (yCenter + 14 + 19 * slot);
            if (k2 < 0 || l2 < 0 || k2 >= 108 || l2 >= 19) continue;
            gfx.method_51446(this.field_22793, choice, x, y);
            this.drawOnLeft(gfx, tooltips, this.field_2800 + 29);
        }
    }

    protected void method_2389(class_332 gfx, float partials, int x, int y) {
        int xCenter = (this.field_22789 - this.field_2792) / 2;
        int slotsX = xCenter + 60;
        int yCenter = (this.field_22790 - this.field_2779) / 2;
        gfx.method_25302(TEXTURE, xCenter, yCenter, 0, 0, this.field_2792, this.field_2779);
        LootRarity rarity = ((ReforgingMenu)this.field_2797).getRarity();
        if (((ReforgingMenu)this.field_2797).method_7611(0).method_7677().method_7960() || rarity == null || ((ReforgingMenu)this.field_2797).needsReset()) {
            for (int slot = 0; slot < 3; ++slot) {
                gfx.method_25302(TEXTURE, slotsX, yCenter + 14 + 19 * slot, 0, 185, 108, 19);
            }
            return;
        }
        int dust = ((ReforgingMenu)this.field_2797).getDustCount();
        int mats = ((ReforgingMenu)this.field_2797).getMatCount();
        int levels = ((ReforgingMenu)this.field_2797).player.field_7520;
        class_487.method_2481().method_2480((long)((ReforgingMenu)this.field_2797).getSeed());
        for (int slot = 0; slot < 3; ++slot) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int dustCost = ((ReforgingMenu)this.field_2797).getDustCost(slot);
            int matCost = ((ReforgingMenu)this.field_2797).getMatCost(slot);
            int levelCost = ((ReforgingMenu)this.field_2797).getLevelCost(slot);
            int maxCost = ((ReforgingMenu)this.field_2797).getMatCost(2);
            String levelStr = "" + levelCost;
            String costStr = "" + matCost;
            int width = 86 - this.field_22793.method_1727(levelStr + maxCost);
            int randTextX = slotsX + 15 + this.field_22793.method_1727("" + maxCost);
            class_5348 randText = class_487.method_2481().method_2479(this.field_22793, width);
            int color = 0x515151;
            if (!(dust >= dustCost && levels >= levelCost && mats >= matCost || this.field_22787.field_1724.method_31549().field_7477)) {
                gfx.method_25302(TEXTURE, slotsX, yCenter + 14 + 19 * slot, 0, 185, 108, 19);
                gfx.method_25302(TEXTURE, slotsX + 1, yCenter + 15 + 19 * slot, 16 * slot, 239, 16, 16);
                gfx.method_51440(this.field_22793, randText, randTextX, yCenter + 16 + 19 * slot, width, color);
                color = this.darken(rarity.getColor().method_27716(), 2);
            } else {
                int k2 = x - (xCenter + 60);
                int l2 = y - (yCenter + 14 + 19 * slot);
                if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                    gfx.method_25302(TEXTURE, slotsX, yCenter + 14 + 19 * slot, 0, 204, 108, 19);
                    color = 0xFFFF80;
                } else {
                    gfx.method_25302(TEXTURE, slotsX, yCenter + 14 + 19 * slot, 0, 166, 108, 19);
                    color = 0xCDCDCD;
                }
                gfx.method_25302(TEXTURE, slotsX + 1, yCenter + 15 + 19 * slot, 16 * slot, 223, 16, 16);
                gfx.method_51440(this.field_22793, randText, randTextX, yCenter + 16 + 19 * slot, width, color);
                color = rarity.getColor().method_27716();
            }
            this.drawBorderedString(gfx, costStr, slotsX + 10, yCenter + 21 + 19 * slot, color, this.darken(color, 4));
            this.drawBorderedString(gfx, levelStr, slotsX + 106 - this.field_22793.method_1727(levelStr), yCenter + 16 + 19 * slot + 7, color, this.darken(color, 4));
        }
    }

    protected int darken(int rColor, int factor) {
        int r = rColor >> 16 & 0xFF;
        int g = rColor >> 8 & 0xFF;
        int b = rColor & 0xFF;
        return (r /= factor) << 16 | (g /= factor) << 8 | (b /= factor);
    }

    protected void drawBorderedString(class_332 gfx, String str, int x, int y, int color, int shadowColor) {
        class_5250 comp = class_2561.method_43470((String)str);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y - 1, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x - 1, y, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y + 1, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x + 1, y, shadowColor, false);
        gfx.method_51439(this.field_22793, (class_2561)comp, x, y, color, false);
    }

    protected void method_2388(class_332 gfx, int x, int y) {
        gfx.method_51439(this.field_22793, this.title, this.field_25267, this.field_25268, 0x404040, false);
        gfx.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((ReforgingMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, k)) continue;
            this.field_22787.field_1761.method_2900(((ReforgingMenu)this.field_2797).field_7763, k);
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

