/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.spell_engine.api.spell.SpellEvents;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public final class SocketAffix
extends Affix {
    public static final Codec<SocketAffix> CODEC = Codec.unit(SocketAffix::new);

    public SocketAffix() {
        super(AffixType.SOCKET);
    }

    @Override
    public boolean canApplyTo(class_1799 socketed, LootCategory cat, LootRarity rarity) {
        return !cat.isNone();
    }

    @Override
    public void addModifiers(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1304 type, BiConsumer<class_1320, class_1322> map) {
        LootCategory cat = LootCategory.forItem(socketed);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)socketed.method_7964().getString());
            return;
        }
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.addModifiers(type, map));
    }

    @Override
    public int getDamageProtection(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1282 source) {
        return SocketHelper.getGemInstances(socketed).map(inst -> inst.getDamageProtection(source)).reduce(0, Integer::sum);
    }

    @Override
    public float getDamageBonus(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1310 creatureType) {
        return SocketHelper.getGemInstances(socketed).map(inst -> Float.valueOf(inst.getDamageBonus(creatureType))).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void doPostAttack(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1309 user, class_1297 target) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.doPostAttack(user, target));
    }

    @Override
    public void doPostHurt(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1309 user, class_1297 attacker) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.doPostHurt(user, attacker));
    }

    @Override
    public void onArrowFired(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1309 user, class_1665 arrow) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.onArrowFired(user, arrow));
    }

    @Override
    @Nullable
    public class_1269 onItemUse(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1838 useinst) {
        return SocketHelper.getGemInstances(socketed).map(inst -> inst.onItemUse(useinst)).filter((Predicate<class_1269>)Predicates.notNull()).max(Enum::compareTo).orElse(null);
    }

    @Override
    public void onArrowImpact(class_1665 arrow, LootRarity itemRarity, float numSockets, class_239 res, class_239.class_240 type) {
        SocketAffix.gems(arrow).forEach(inst -> inst.onArrowImpact(arrow, res, type));
    }

    @Override
    public float onShieldBlock(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1309 entity, class_1282 source, float amount) {
        return SocketHelper.getGemInstances(socketed).map(inst -> Float.valueOf(inst.onShieldBlock(entity, source, amount))).max(Float::compareTo).orElse(Float.valueOf(amount)).floatValue();
    }

    @Override
    public void onBlockBreak(class_1799 socketed, LootRarity itemRarity, float numSockets, class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.onBlockBreak(player, world, pos, state));
    }

    @Override
    public float getDurabilityBonusPercentage(class_1799 socketed, LootRarity rarity, float level, class_3222 user) {
        return (float)SocketHelper.getGemInstances(socketed).mapToDouble(inst -> inst.getDurabilityBonusPercentage(user)).sum();
    }

    @Override
    public float onHurt(class_1799 socketed, LootRarity rarity, float level, class_1282 src, class_1309 ent, float amount) {
        MutableFloat lambdaSilly = new MutableFloat(amount);
        SocketHelper.getGemInstances(socketed).forEachOrdered(inst -> lambdaSilly.setValue(inst.onHurt(src, ent, amount)));
        return lambdaSilly.getValue().floatValue();
    }

    @Override
    public void getEnchantmentLevels(class_1799 socketed, LootRarity rarity, float level, Map<class_1887, Integer> enchantments) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.getEnchantmentLevels(enchantments));
    }

    @Override
    public void modifyLoot(class_1799 socketed, LootRarity rarity, float level, ObjectArrayList<class_1799> loot, class_47 ctx) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.modifyLoot(loot, ctx));
    }

    @Override
    public void onCast(class_1799 socketed, LootRarity rarity, float level, SpellEvents.ProjectileLaunchEvent event) {
        SocketHelper.getGemInstances(socketed).forEach(inst -> inst.onCast(event));
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    private static Stream<GemInstance> gems(class_1665 arrow) {
        return Stream.empty();
    }
}

