/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket;

import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.event.GetItemSocketsEvent;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.util.CachedObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class SocketHelper {
    public static final class_2960 GEMS_CACHED_OBJECT = Apotheosis.loc("gems");
    public static final String AFFIX_DATA = "affix_data";
    public static final String GEMS = "gems";
    public static final String SOCKETS = "sockets";

    public static List<class_1799> getGems(class_1799 stack) {
        return (List)CachedObject.CachedObjectSource.getOrCreate((class_1799)stack, (class_2960)GEMS_CACHED_OBJECT, SocketHelper::getGemsImpl, (ToIntFunction)CachedObject.hashSubkey((String)AFFIX_DATA));
    }

    private static List<class_1799> getGemsImpl(class_1799 stack) {
        int size = SocketHelper.getSockets(stack);
        if (size <= 0 || stack.method_7960()) {
            return Collections.emptyList();
        }
        class_2371 gems = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        int i = 0;
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        if (afxData != null && afxData.method_10545(GEMS)) {
            class_2499 gemData = afxData.method_10554(GEMS, 10);
            for (class_2520 tag : gemData) {
                class_1799 gemStack = class_1799.method_7915((class_2487)((class_2487)tag));
                gemStack.method_7939(1);
                if (GemInstance.unsocketed(gemStack).isValidUnsocketed()) {
                    gems.set(i++, gemStack);
                }
                if (i < size) continue;
                break;
            }
        }
        return ImmutableList.copyOf((Collection)gems);
    }

    public static Stream<GemInstance> getGemInstances(class_1799 stack) {
        return SocketHelper.getGems(stack).stream().map(gemStack -> GemInstance.socketed(stack, gemStack)).filter(GemInstance::isValid);
    }

    public static void setGems(class_1799 stack, List<class_1799> gems) {
        class_2487 afxData = stack.method_7911(AFFIX_DATA);
        class_2499 gemData = new class_2499();
        for (class_1799 s : gems) {
            gemData.add((Object)s.method_7953(new class_2487()));
        }
        afxData.method_10566(GEMS, (class_2520)gemData);
    }

    public static int getSockets(class_1799 stack) {
        class_2487 afxData = stack.method_7941(AFFIX_DATA);
        int sockets = afxData != null ? afxData.method_10550(SOCKETS) : 0;
        GetItemSocketsEvent event = new GetItemSocketsEvent(stack, sockets);
        return sockets;
    }

    public static void setSockets(class_1799 stack, int sockets) {
        stack.method_7911(AFFIX_DATA).method_10569(SOCKETS, sockets);
    }

    public static boolean hasEmptySockets(class_1799 stack) {
        return SocketHelper.getGems(stack).stream().map(GemItem::getGem).map(DynamicHolder::getOptional).anyMatch(Optional::isEmpty);
    }

    public static int getFirstEmptySocket(class_1799 stack) {
        List<class_1799> gems = SocketHelper.getGems(stack);
        for (int socket = 0; socket < gems.size(); ++socket) {
            DynamicHolder<Gem> gem = GemItem.getGem(gems.get(socket));
            if (gem.isBound()) continue;
            return socket;
        }
        return 0;
    }

    public static void loadSocketAffix(class_1799 stack, Map<DynamicHolder<? extends Affix>, AffixInstance> affixes) {
        int sockets = SocketHelper.getSockets(stack);
        if (sockets > 0) {
            affixes.put(Adventure.Affixes.SOCKET, new AffixInstance(Adventure.Affixes.SOCKET, stack, RarityRegistry.getMinRarity(), sockets));
        }
    }
}

