/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public class GemItem
extends class_1792 {
    public static final String HAS_REFRESHED = "has_refreshed";
    public static final String UUID_ARRAY = "uuids";
    public static final String GEM = "gem";

    public GemItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 pLevel, List<class_2561> tooltip, class_1836 isAdvanced) {
        GemInstance inst = GemInstance.unsocketed(stack);
        if (!inst.isValidUnsocketed()) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Errored gem with no bonus!").method_27692(class_124.field_1080));
            return;
        }
        ((Gem)inst.gem().get()).addInformation(stack, (LootRarity)inst.rarity().get(), tooltip::add);
    }

    public class_2561 method_7864(class_1799 pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.method_7864(pStack);
        }
        class_5250 comp = class_2561.method_43471((String)this.method_7866(pStack));
        comp = class_2561.method_43469((String)("item.zenith.gem." + inst.rarity().getId()), (Object[])new Object[]{comp});
        return comp.method_27696(class_2583.field_24360.method_27703(((LootRarity)inst.rarity().get()).getColor()));
    }

    public String method_7866(class_1799 pStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(pStack);
        if (!gem.isBound()) {
            return super.method_7876();
        }
        return super.method_7866(pStack) + "." + gem.getId();
    }

    public boolean method_7886(class_1799 pStack) {
        GemInstance inst = GemInstance.unsocketed(pStack);
        if (!inst.isValidUnsocketed()) {
            return super.method_7886(pStack);
        }
        return inst.isMaxRarity();
    }

    public boolean method_24357(class_1282 src) {
        return super.method_24357(src) && !src.method_49708(class_8111.field_42357);
    }

    public static void fillItemCategory(class_1761.class_7704 out) {
        GemRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gem::getId)).forEach(gem -> {
            class_1799[] sortedStacks = new class_1799[RarityRegistry.INSTANCE.getValues().size()];
            for (LootRarity rarity : RarityRegistry.INSTANCE.getValues()) {
                if (gem.clamp(rarity) != rarity) continue;
                class_1799 stack = new class_1799((class_1935)Adventure.Items.GEM);
                GemItem.setGem(stack, gem);
                AffixHelper.setRarity(stack, rarity);
                sortedStacks[rarity.ordinal()] = stack;
            }
            out.method_45423(Stream.of(sortedStacks).filter(Objects::nonNull).toList());
        });
    }

    public static List<UUID> getUUIDs(class_1799 gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        if (!gem.isBound()) {
            return Collections.emptyList();
        }
        return GemItem.getOrCreateUUIDs(gemStack.method_7948(), ((Gem)gem.get()).getNumberOfUUIDs());
    }

    @Nullable
    public String getCreatorModId(class_1799 stack) {
        GemInstance inst = GemInstance.unsocketed(stack);
        if (inst.isValidUnsocketed()) {
            return inst.gem().getId().method_12836();
        }
        return super.getCreatorModId(stack);
    }

    public static List<UUID> getOrCreateUUIDs(class_2487 tag, int numUUIDs) {
        if (numUUIDs == 0) {
            return Collections.emptyList();
        }
        if (tag.method_10545(UUID_ARRAY)) {
            class_2499 list = tag.method_10554(UUID_ARRAY, 11);
            ArrayList<UUID> ret = new ArrayList<UUID>(list.size());
            for (class_2520 t : list) {
                ret.add(class_2512.method_25930((class_2520)t));
            }
            if (ret.size() < numUUIDs) {
                return GemItem.generateAndSave(ret, numUUIDs, tag);
            }
            return ret;
        }
        return GemItem.generateAndSave(new ArrayList<UUID>(numUUIDs), numUUIDs, tag);
    }

    private static List<UUID> generateAndSave(List<UUID> base, int amount, class_2487 tag) {
        int needed = amount - base.size();
        for (int i = 0; i < needed; ++i) {
            base.add(UUID.randomUUID());
        }
        class_2499 list = new class_2499();
        for (UUID id : base) {
            list.add((Object)class_2512.method_25929((UUID)id));
        }
        tag.method_10566(UUID_ARRAY, (class_2520)list);
        return base;
    }

    public static void setGem(class_1799 gemStack, Gem gem) {
        gemStack.method_7948().method_10582(GEM, gem.getId().toString());
    }

    public static DynamicHolder<Gem> getGem(class_1799 gem) {
        if (gem.method_7909() != Adventure.Items.GEM || !gem.method_7985()) {
            return GemRegistry.INSTANCE.emptyHolder();
        }
        class_2487 tag = gem.method_7969();
        return GemRegistry.INSTANCE.holder(new class_2960(tag.method_10558(GEM)));
    }
}

