/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_7923;

public class AttributeBonus
extends GemBonus {
    public static Codec<AttributeBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(AttributeBonus.gemClass(), (App)class_7923.field_41190.method_39673().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(class_1322.class_1323.class).fieldOf("operation").forGetter(a -> a.operation), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, AttributeBonus::new));
    protected final class_1320 attribute;
    protected final class_1322.class_1323 operation;
    protected final Map<LootRarity, StepFunction> values;

    public AttributeBonus(GemClass gemClass, class_1320 attr, class_1322.class_1323 op, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("attribute"), gemClass);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
    }

    @Override
    public void addModifiers(class_1799 gem, LootRarity rarity, BiConsumer<class_1320, class_1322> map) {
        map.accept(this.attribute, this.read(gem, rarity, GemItem.getUUIDs(gem).get(0)));
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        return IFormattableAttribute.toComponent((class_1320)this.attribute, (class_1322)this.read(gem, rarity, UUID.randomUUID()), (class_1836)AttributesLib.getTooltipFlag());
    }

    @Override
    public AttributeBonus validate() {
        Preconditions.checkNotNull((Object)this.attribute, (Object)"Invalid AttributeBonus with null attribute");
        Preconditions.checkNotNull((Object)this.operation, (Object)"Invalid AttributeBonus with null operation");
        Preconditions.checkNotNull(this.values, (Object)"Invalid AttributeBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 1;
    }

    public class_1322 read(class_1799 gem, LootRarity rarity, UUID id) {
        return new class_1322(id, "apoth.gem_modifier", (double)this.values.get(rarity).get(0.0f), this.operation);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

