/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class EnchantmentBonus
extends GemBonus {
    protected final class_1887 ench;
    protected final boolean mustExist;
    protected final boolean global;
    protected final Map<LootRarity, Integer> values;
    public static Codec<EnchantmentBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(EnchantmentBonus.gemClass(), (App)class_7923.field_41176.method_39673().fieldOf("enchantment").forGetter(a -> a.ench), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"must_exist", (Object)false).forGetter(a -> a.mustExist), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"global", (Object)false).forGetter(a -> a.global), (App)LootRarity.mapCodec(Codec.intRange((int)1, (int)127)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, EnchantmentBonus::new));

    public EnchantmentBonus(GemClass gemClass, class_1887 ench, boolean mustExist, boolean global, Map<LootRarity, Integer> values) {
        super(Apotheosis.loc("enchantment"), gemClass);
        this.ench = ench;
        this.values = values;
        this.mustExist = mustExist;
        this.global = global;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        int level = this.values.get(rarity);
        String desc = "bonus." + this.getId() + ".desc";
        if (this.global) {
            desc = desc + ".global";
        } else if (this.mustExist) {
            desc = desc + ".mustExist";
        }
        class_5250 enchName = class_2561.method_43471((String)this.ench.method_8184());
        class_2583 style = this.ench.method_8179(0).method_10866();
        if (style.method_10973() != null && style.method_10973().method_27716() != class_124.field_1080.method_532().intValue()) {
            enchName.method_27696(style);
        }
        return class_2561.method_43469((String)desc, (Object[])new Object[]{level, class_2561.method_43471((String)("misc.zenith.level" + (level > 1 ? ".many" : ""))), enchName}).method_27692(class_124.field_1060);
    }

    @Override
    public void getEnchantmentLevels(class_1799 gemStack, LootRarity rarity, Map<class_1887, Integer> enchantments) {
        int level = this.values.get(rarity);
        if (this.global) {
            for (class_1887 e : enchantments.keySet()) {
                enchantments.computeIfPresent(e, (key, val) -> val > 0 ? val + level : 0);
            }
        } else if (this.mustExist) {
            enchantments.computeIfPresent(this.ench, (key, val) -> val > 0 ? val + level : 0);
        } else {
            enchantments.merge(this.ench, level, Integer::sum);
        }
    }

    @Override
    public GemBonus validate() {
        Preconditions.checkNotNull((Object)this.ench, (Object)"Invalid DamageReductionBonus with null type");
        Preconditions.checkNotNull(this.values, (Object)"Invalid DamageReductionBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

