/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.PotionAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3544;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class PotionBonus
extends GemBonus {
    public static final Codec<PotionBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(PotionBonus.gemClass(), (App)class_7923.field_41174.method_39673().fieldOf("mob_effect").forGetter(a -> a.effect), (App)PotionAffix.Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)LootRarity.mapCodec(EffectData.CODEC).fieldOf("values").forGetter(a -> a.values), (App)PlaceboCodecs.nullableField((Codec)Codec.BOOL, (String)"stack_on_reapply", (Object)false).forGetter(a -> a.stackOnReapply)).apply((Applicative)inst, PotionBonus::new));
    protected final class_1291 effect;
    protected final PotionAffix.Target target;
    protected final Map<LootRarity, EffectData> values;
    protected final boolean stackOnReapply;

    public PotionBonus(GemClass gemClass, class_1291 effect, PotionAffix.Target target, Map<LootRarity, EffectData> values, boolean stackOnReapply) {
        super(Apotheosis.loc("mob_effect"), gemClass);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.stackOnReapply = stackOnReapply;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        class_1293 inst = this.values.get(rarity).build(this.effect);
        class_5250 comp = this.target.toComponent(PotionBonus.toComponent(inst)).method_27692(class_124.field_1054);
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0) {
            class_5250 cd = class_2561.method_43469((String)"affix.zenith.cooldown", (Object[])new Object[]{class_3544.method_15439((int)cooldown)});
            comp = comp.method_27693(" ").method_10852((class_2561)cd);
        }
        if (this.stackOnReapply) {
            comp = comp.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"affix.zenith.stacking"));
        }
        return comp;
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public void doPostHurt(class_1799 gem, LootRarity rarity, class_1309 user, class_1297 attacker) {
        if (this.target == PotionAffix.Target.HURT_SELF) {
            this.applyEffect(user, rarity);
        } else if (this.target == PotionAffix.Target.HURT_ATTACKER && attacker instanceof class_1309) {
            class_1309 tLiving = (class_1309)attacker;
            this.applyEffect(tLiving, rarity);
        }
    }

    @Override
    public void doPostAttack(class_1799 gem, LootRarity rarity, class_1309 user, class_1297 target) {
        if (this.target == PotionAffix.Target.ATTACK_SELF) {
            this.applyEffect(user, rarity);
        } else if (this.target == PotionAffix.Target.ATTACK_TARGET && target instanceof class_1309) {
            class_1309 tLiving = (class_1309)target;
            this.applyEffect(tLiving, rarity);
        }
    }

    @Override
    public void onBlockBreak(class_1799 gem, LootRarity rarity, class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        if (this.target == PotionAffix.Target.BREAK_SELF) {
            this.applyEffect((class_1309)player, rarity);
        }
    }

    @Override
    public void onArrowImpact(class_1665 arrow, LootRarity rarity, class_239 res, class_239.class_240 type) {
        class_1297 class_12972;
        if (this.target == PotionAffix.Target.ARROW_SELF) {
            class_1297 class_12973 = arrow.method_24921();
            if (class_12973 instanceof class_1309) {
                class_1309 owner = (class_1309)class_12973;
                this.applyEffect(owner, rarity);
            }
        } else if (this.target == PotionAffix.Target.ARROW_TARGET && type == class_239.class_240.field_1331 && (class_12972 = ((class_3966)res).method_17782()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.applyEffect(target, rarity);
        }
    }

    @Override
    public float onShieldBlock(class_1799 stack, LootRarity rarity, class_1309 entity, class_1282 source, float amount) {
        class_1297 class_12972;
        if (this.target == PotionAffix.Target.BLOCK_SELF) {
            this.applyEffect(entity, rarity);
        } else if (this.target == PotionAffix.Target.BLOCK_ATTACKER && (class_12972 = source.method_5526()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            this.applyEffect(target, rarity);
        }
        return amount;
    }

    protected int getCooldown(LootRarity rarity) {
        EffectData data = this.values.get(rarity);
        return data.cooldown;
    }

    private void applyEffect(class_1309 target, LootRarity rarity) {
        int cooldown = this.getCooldown(rarity);
        if (cooldown != 0 && Affix.isOnCooldown(this.getId(), cooldown, target)) {
            return;
        }
        EffectData data = this.values.get(rarity);
        class_1293 inst = target.method_6112(this.effect);
        if (this.stackOnReapply && inst != null) {
            if (inst != null) {
                class_1293 newInst = new class_1293(this.effect, Math.max(inst.method_5584(), data.duration), inst.method_5578() + 1 + data.amplifier);
                target.method_6092(newInst);
            }
        } else {
            target.method_6092(data.build(this.effect));
        }
        Affix.startCooldown(this.getId(), target);
    }

    public static class_2561 toComponent(class_1293 inst) {
        class_5250 mutablecomponent = class_2561.method_43471((String)inst.method_5586());
        class_1291 mobeffect = inst.method_5579();
        if (inst.method_5578() > 0) {
            mutablecomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, class_2561.method_43471((String)("potion.potency." + inst.method_5578()))});
        }
        if (inst.method_5584() > 20) {
            mutablecomponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, class_1292.method_5577((class_1293)inst, (float)1.0f)});
        }
        return mutablecomponent.method_27692(mobeffect.method_18792().method_18793());
    }

    @Override
    public PotionBonus validate() {
        Preconditions.checkNotNull((Object)this.effect, (Object)"Null mob effect");
        Preconditions.checkNotNull((Object)((Object)this.target), (Object)"Null target");
        Preconditions.checkNotNull(this.values, (Object)"Null values map");
        return this;
    }

    public record EffectData(int duration, int amplifier, int cooldown) {
        private static Codec<EffectData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("duration").forGetter(EffectData::duration), (App)Codec.INT.fieldOf("amplifier").forGetter(EffectData::amplifier), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"cooldown", (Object)0).forGetter(EffectData::cooldown)).apply((Applicative)inst, EffectData::new));

        public class_1293 build(class_1291 effect) {
            return new class_1293(effect, this.duration, this.amplifier);
        }
    }
}

