/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import dev.architectury.event.EventResult;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GemCuttingCategory;
import dev.shadowsoffire.apotheosis.adventure.compat.GemCuttingDisplay;
import dev.shadowsoffire.apotheosis.adventure.compat.SalvagingREICategory;
import dev.shadowsoffire.apotheosis.adventure.compat.SalvagingREIDisplay;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.util.GemIngredient;
import dev.shadowsoffire.apotheosis.util.REIUtil;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Comparator;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class AdventureREIPlugin
implements REIClientPlugin {
    public static final class_2960 TEXTURES = new class_2960("zenith", "textures/gui/salvage_jei.png");

    public String getPluginProviderName() {
        return Apotheosis.loc("adventure").toString();
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (!Apotheosis.enableAdventure || !AdventureConfig.collapsableGemEntries) {
            return;
        }
        GemRegistry.INSTANCE.getValues().stream().sorted(Comparator.comparing(Gem::getId)).forEach(gem -> {
            String gemId = "item.zenith.gem." + gem.getId().method_12836() + ":" + gem.getId().method_12832();
            registry.group(gem.getId(), (class_2561)class_2561.method_43471((String)gemId), VanillaEntryTypes.ITEM, itemStackEntryStack -> {
                class_1799 stack = ((class_1799)itemStackEntryStack.getValue()).method_7972();
                if (!stack.method_31574(Adventure.Items.GEM)) {
                    return false;
                }
                DynamicHolder<Gem> gemHolder = GemItem.getGem(stack);
                if (!gemHolder.isBound()) {
                    return false;
                }
                return ((Gem)gemHolder.get()).getId() == gem.getId();
            });
        });
    }

    public void registerCategories(CategoryRegistry registry) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        registry.add((DisplayCategory)new SalvagingREICategory());
        registry.addWorkstations(SalvagingREIDisplay.ID, new EntryIngredient[]{EntryIngredients.of((class_1799)new class_1799((class_1935)Adventure.Blocks.SALVAGING_TABLE))});
        registry.add((DisplayCategory)new GemCuttingCategory());
        registry.addWorkstations(GemCuttingDisplay.ID, new EntryIngredient[]{EntryIngredients.of((class_1799)new class_1799((class_1935)Adventure.Blocks.GEM_CUTTING_TABLE))});
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        if (stage != ReloadStage.END || !manager.equals((Object)PluginManager.getClientInstance())) {
            return;
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        registry.registerFiller(SalvagingRecipe.class, SalvagingREIDisplay::new);
        registry.registerFiller(GemCuttingDisplay.GemCuttingRecipe.class, GemCuttingDisplay::new);
        ArrayList gemlist = new ArrayList();
        RarityRegistry.INSTANCE.getValues().forEach(lootRarity -> gemlist.add(new GemIngredient((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder((CodecProvider)lootRarity)).toVanilla()));
        DefaultInformationDisplay info = DefaultInformationDisplay.createFromEntries((EntryIngredient)EntryIngredients.ofIngredient((class_1856)((class_1856)gemlist.get(0))), (class_2561)class_2561.method_43470((String)""));
        info.line((class_2561)class_2561.method_43471((String)"info.zenith.socketing"));
        registry.add((Display)info);
        REIUtil.addInfo(registry, (class_1935)Adventure.Items.GEM_DUST, "info.zenith.gem_crushing");
        REIUtil.addInfo(registry, (class_1935)Adventure.Items.VIAL_OF_EXTRACTION, "info.zenith.gem_extraction");
        REIUtil.addInfo(registry, (class_1935)Adventure.Items.VIAL_OF_EXPULSION, "info.zenith.gem_expulsion");
        REIUtil.addInfo(registry, (class_1935)Adventure.Items.VIAL_OF_UNNAMING, "info.zenith.unnaming");
        for (Gem g : GemRegistry.INSTANCE.getValues()) {
            LootRarity max = (LootRarity)RarityRegistry.getMaxRarity().get();
            for (LootRarity r = (LootRarity)RarityRegistry.getMinRarity().get(); r != max; r = r.next()) {
                if (g.clamp(r) != r) continue;
                registry.add((Object)new GemCuttingDisplay.GemCuttingRecipe(g, r));
            }
        }
        registry.registerVisibilityPredicate((DisplayVisibilityPredicate)new HideSmithingRecipes());
    }

    private static class HideSmithingRecipes
    implements DisplayVisibilityPredicate {
        private HideSmithingRecipes() {
        }

        public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
            class_1860 recipe;
            Object origin = DisplayRegistry.getInstance().getDisplayOrigin(display);
            if (origin instanceof class_1860 && (recipe = (class_1860)origin).method_8114().method_12836().equals("zenith")) {
                return switch (recipe.method_8114().method_12832()) {
                    case "unnaming" -> EventResult.interruptFalse();
                    case "socketing" -> EventResult.interruptFalse();
                    case "extraction" -> EventResult.interruptFalse();
                    case "expulsion" -> EventResult.interruptFalse();
                    case "add_sockets" -> EventResult.interruptFalse();
                    case "superior_add_sockets" -> EventResult.interruptFalse();
                    default -> EventResult.pass();
                };
            }
            return EventResult.pass();
        }
    }
}

