/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingMenu;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class GemCuttingDisplay
implements Display {
    public static final CategoryIdentifier<GemCuttingDisplay> ID = CategoryIdentifier.of((String)"zenith", (String)"gem_cutting");
    private final GemCuttingRecipe recipe;

    public GemCuttingDisplay(GemCuttingRecipe recipe) {
        this.recipe = recipe;
    }

    public List<EntryIngredient> getInputEntries() {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.add(this.recipe.gem);
        list.add(this.recipe.dust);
        list.add(this.recipe.gem);
        list.addAll(Arrays.asList(this.recipe.materials));
        return list.stream().map(EntryIngredients::of).toList();
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredients.of((class_1799)this.recipe.out));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ID;
    }

    public GemCuttingRecipe getRecipe() {
        return this.recipe;
    }

    public static class GemCuttingRecipe {
        protected final class_1799 out;
        protected final class_1799 gem;
        protected final class_1799 dust;
        protected final class_1799[] materials;

        public GemCuttingRecipe(Gem gem, LootRarity rarity) {
            this.out = GemRegistry.createGemStack(gem, rarity.next());
            this.gem = GemRegistry.createGemStack(gem, rarity);
            this.dust = new class_1799((class_1935)Adventure.Items.GEM_DUST, GemCuttingMenu.getDustCost(rarity));
            LootRarity min = (LootRarity)RarityRegistry.getMinRarity().get();
            if (rarity == min) {
                this.materials = new class_1799[2];
                this.materials[0] = new class_1799((class_1935)rarity.getMaterial(), 3);
                this.materials[1] = new class_1799((class_1935)rarity.next().getMaterial(), 1);
            } else if ("ancient".equals(RarityRegistry.INSTANCE.getKey(rarity.next()).method_12832())) {
                this.materials = new class_1799[2];
                this.materials[0] = new class_1799((class_1935)rarity.prev().getMaterial(), 9);
                this.materials[1] = new class_1799((class_1935)rarity.getMaterial(), 3);
            } else {
                this.materials = new class_1799[3];
                this.materials[0] = new class_1799((class_1935)rarity.prev().getMaterial(), 9);
                this.materials[1] = new class_1799((class_1935)rarity.getMaterial(), 3);
                this.materials[2] = new class_1799((class_1935)rarity.next().getMaterial(), 1);
            }
        }
    }
}

