/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.compat;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.compat.AdventureEMIPlugin;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class SalvagingEMIRecipe
implements EmiRecipe {
    private static final class_2960 TEXTURES = new class_2960("zenith", "textures/gui/salvage_jei.png");
    private final List<SalvagingRecipe.OutputData> outputs;
    private final class_2960 id;
    private final EmiIngredient input;

    public SalvagingEMIRecipe(SalvagingRecipe recipe) {
        this.input = EmiIngredient.of((class_1856)recipe.getInput());
        this.outputs = recipe.getOutputs();
        this.id = recipe.method_8114();
    }

    public EmiRecipeCategory getCategory() {
        return AdventureEMIPlugin.SALVAGING;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs.stream().map(SalvagingRecipe.OutputData::getStack).map(EmiStack::of).toList();
    }

    public int getDisplayWidth() {
        return 98;
    }

    public int getDisplayHeight() {
        return 74;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(TEXTURES, 1, 1, 98, 74, 0, 0);
        widgets.addSlot(this.input, 5, 29).drawBack(false);
        int indx = 0;
        for (SalvagingRecipe.OutputData data : this.outputs) {
            int pX = 59 + 18 * (indx % 2);
            int pY = 11 + 18 * (indx / 2);
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)data.getStack()), pX, pY).recipeContext((EmiRecipe)this).drawBack(false);
            ++indx;
        }
        widgets.addDrawable(0, 0, 100, 100, (gfx, mouseX, mouseY, delta) -> {
            class_327 font = class_310.method_1551().field_1772;
            class_4587 pose = gfx.method_51448();
            int idx = 0;
            for (SalvagingRecipe.OutputData data : this.outputs) {
                pose.method_22903();
                pose.method_46416(0.0f, 0.0f, 200.0f);
                String text = String.format("%d-%d", data.getMin(), data.getMax());
                float x = (float)(59 + 18 * (idx % 2)) + (16.0f - (float)font.method_1727(text) * 0.5f);
                float y = 23.0f + (float)(18 * (idx / 2));
                float scale = 0.5f;
                pose.method_22905(scale, scale, 1.0f);
                gfx.method_25303(font, text, (int)(x / scale), (int)(y / scale), 0xFFFFFF);
                ++idx;
                pose.method_22909();
            }
        });
    }
}

