/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import io.github.fabricators_of_create.porting_lib.item.ShieldBlockItem;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import io.github.fabricators_of_create.porting_lib.util.ServerLifecycleHooks;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1642;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2190;
import net.minecraft.class_5134;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class LootCategory {
    private static final Map<String, LootCategory> BY_ID_INTERNAL = new HashMap<String, LootCategory>();
    private static final List<LootCategory> VALUES_INTERNAL = new LinkedList<LootCategory>();
    public static final Map<String, LootCategory> BY_ID = Collections.unmodifiableMap(BY_ID_INTERNAL);
    public static final List<LootCategory> VALUES = Collections.unmodifiableList(VALUES_INTERNAL);
    public static final Codec<LootCategory> CODEC = class_5699.method_39508(LootCategory::getName, LootCategory::byId);
    public static final Codec<Set<LootCategory>> SET_CODEC = PlaceboCodecs.setOf(CODEC);
    public static final LootCategory BOW = LootCategory.register("bow", s -> s.method_7909() instanceof class_1753, LootCategory.arr(class_1304.field_6173, class_1304.field_6171));
    public static final LootCategory CROSSBOW = LootCategory.register("crossbow", s -> s.method_7909() instanceof class_1764, LootCategory.arr(class_1304.field_6173, class_1304.field_6171));
    public static final LootCategory PICKAXE = LootCategory.register("pickaxe", s -> s.canPerformAction(ToolActions.PICKAXE_DIG), LootCategory.arr(class_1304.field_6173));
    public static final LootCategory SHOVEL = LootCategory.register("shovel", s -> s.canPerformAction(ToolActions.SHOVEL_DIG), LootCategory.arr(class_1304.field_6173));
    public static final LootCategory HEAVY_WEAPON = LootCategory.register("heavy_weapon", new ShieldBreakerTest(), LootCategory.arr(class_1304.field_6173));
    public static final LootCategory HELMET = LootCategory.register("helmet", LootCategory.armorSlot(class_1304.field_6169), LootCategory.arr(class_1304.field_6169));
    public static final LootCategory CHESTPLATE = LootCategory.register("chestplate", LootCategory.armorSlot(class_1304.field_6174), LootCategory.arr(class_1304.field_6174));
    public static final LootCategory LEGGINGS = LootCategory.register("leggings", LootCategory.armorSlot(class_1304.field_6172), LootCategory.arr(class_1304.field_6172));
    public static final LootCategory BOOTS = LootCategory.register("boots", LootCategory.armorSlot(class_1304.field_6166), LootCategory.arr(class_1304.field_6166));
    public static final LootCategory SHIELD = LootCategory.register("shield", s -> s.canPerformAction(ToolActions.SHIELD_BLOCK), LootCategory.arr(class_1304.field_6173, class_1304.field_6171));
    public static final LootCategory TRIDENT = LootCategory.register("trident", s -> s.method_7909() instanceof class_1835, LootCategory.arr(class_1304.field_6173));
    public static final LootCategory SWORD = LootCategory.register("sword", s -> s.method_7909() instanceof class_1829 || s.canPerformAction(ToolActions.SWORD_DIG) || s.method_7909().getAttributeModifiers(s, class_1304.field_6173).get((Object)class_5134.field_23721).stream().anyMatch(m -> m.method_6186() > 0.0), LootCategory.arr(class_1304.field_6173));
    public static final LootCategory NONE = LootCategory.register("none", (Predicate<class_1799>)Predicates.alwaysFalse(), new class_1304[0]);
    private final String name;
    private final Predicate<class_1799> validator;
    private final class_1304[] slots;

    private LootCategory(String name, Predicate<class_1799> validator, class_1304[] slots) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.validator = (Predicate)Preconditions.checkNotNull(validator);
        this.slots = (class_1304[])Preconditions.checkNotNull((Object)slots);
    }

    public String getDescId() {
        return "text.zenith.category." + this.name;
    }

    public String getDescIdPlural() {
        return this.getDescId() + ".plural";
    }

    public String getName() {
        return this.name;
    }

    public class_1304[] getSlots() {
        return this.slots;
    }

    public boolean isValid(class_1799 stack) {
        return this.validator.test(stack);
    }

    public boolean isArmor() {
        return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
    }

    public boolean isBreaker() {
        return this == PICKAXE || this == SHOVEL;
    }

    public boolean isRanged() {
        return this == BOW || this == CROSSBOW || this == TRIDENT;
    }

    public boolean isDefensive() {
        return this.isArmor() || this == SHIELD;
    }

    public boolean isLightWeapon() {
        return this == SWORD || this == TRIDENT;
    }

    public boolean isWeapon() {
        return this == SWORD || this == HEAVY_WEAPON || this == TRIDENT;
    }

    public boolean isWeaponOrShield() {
        return this.isLightWeapon() || this == SHIELD;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public String toString() {
        return String.format("LootCategory[%s]", this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof LootCategory)) return false;
        LootCategory cat = (LootCategory)obj;
        if (!cat.name.equals(this.name)) return false;
        return true;
    }

    public static final LootCategory register(@Nullable LootCategory orderRef, String name, Predicate<class_1799> validator, class_1304[] slots) {
        LootCategory cat = new LootCategory(name, validator, slots);
        if (BY_ID_INTERNAL.containsKey(name)) {
            throw new IllegalArgumentException("Cannot register a loot category with a duplicate name.");
        }
        BY_ID_INTERNAL.put(name, cat);
        int idx = VALUES_INTERNAL.size();
        if (orderRef != null) {
            idx = VALUES_INTERNAL.indexOf(orderRef);
        }
        VALUES_INTERNAL.add(idx, cat);
        return cat;
    }

    @Nullable
    public static LootCategory byId(String name) {
        return BY_ID.get(name);
    }

    public static LootCategory forItem(class_1799 item) {
        if (item.method_7960()) {
            return NONE;
        }
        LootCategory override = AdventureConfig.TYPE_OVERRIDES.get(class_7923.field_41178.method_10221((Object)item.method_7909()));
        if (override != null) {
            return override;
        }
        for (LootCategory c : VALUES) {
            if (!c.isValid(item)) continue;
            return c;
        }
        return NONE;
    }

    private static class_1304[] arr(class_1304 ... s) {
        return s;
    }

    private static Predicate<class_1799> armorSlot(class_1304 slot) {
        return stack -> {
            class_1747 bi;
            class_1792 patt9438$temp;
            if (stack.method_31574(class_1802.field_17519) || (patt9438$temp = stack.method_7909()) instanceof class_1747 && (bi = (class_1747)patt9438$temp).method_7711() instanceof class_2190) {
                return false;
            }
            return class_1309.method_32326((class_1799)stack) == slot;
        };
    }

    static final LootCategory register(String name, Predicate<class_1799> validator, class_1304[] slots) {
        return LootCategory.register(null, name, validator, slots);
    }

    private static class ShieldBreakerTest
    implements Predicate<class_1799> {
        private class_1642 attacker;
        private class_1642 holder;

        private ShieldBreakerTest() {
        }

        @Override
        public boolean test(class_1799 t) {
            block8: {
                try {
                    class_1792 class_17922;
                    class_1799 shield = new class_1799((class_1935)class_1802.field_8255);
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (this.attacker == null && server != null) {
                        this.attacker = new class_1642((class_1937)server.method_3847(class_1937.field_25179));
                        this.holder = new class_1642((class_1937)server.method_3847(class_1937.field_25179));
                    }
                    if (this.holder != null) {
                        this.holder.method_6122(class_1268.field_5810, shield);
                    }
                    if ((class_17922 = t.method_7909()) instanceof ShieldBlockItem) {
                        ShieldBlockItem sb = (ShieldBlockItem)class_17922;
                    } else if (!(t.method_7909() instanceof class_1743)) break block8;
                    if (t.method_7909() instanceof ShieldBlockItem) {
                        return ((ShieldBlockItem)t.method_7909()).canDisableShield(t, shield, (class_1309)this.holder, (class_1309)this.attacker);
                    }
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return false;
        }
    }
}

