/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.ListCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LootRarity
implements CodecProvider<LootRarity>,
WeightedDynamicRegistry.ILuckyWeighted,
Comparable<LootRarity> {
    public static final Codec<LootRarity> LOAD_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_5251.field_39242.fieldOf("color").forGetter(LootRarity::getColor), (App)class_7923.field_41178.method_39673().fieldOf("material").forGetter(LootRarity::getMaterial), (App)Codec.INT.fieldOf("ordinal").forGetter(LootRarity::ordinal), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(WeightedDynamicRegistry.ILuckyWeighted::getWeight), (App)PlaceboCodecs.nullableField((Codec)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE), (String)"quality", (Object)Float.valueOf(0.0f)).forGetter(WeightedDynamicRegistry.ILuckyWeighted::getQuality), (App)new ListCodec(LootRule.CODEC).fieldOf("rules").forGetter(LootRarity::getRules)).apply((Applicative)inst, LootRarity::new));
    @Deprecated
    public static final Codec<DynamicHolder<LootRarity>> HOLDER_CODEC = class_5699.method_39240(() -> Codec.STRING.xmap(RarityRegistry::convertId, class_2960::toString).xmap(arg_0 -> ((RarityRegistry)RarityRegistry.INSTANCE).holder(arg_0), DynamicHolder::getId));
    public static final Codec<LootRarity> CODEC = class_5699.method_39240(() -> HOLDER_CODEC.xmap(DynamicHolder::get, arg_0 -> ((RarityRegistry)RarityRegistry.INSTANCE).holder(arg_0)));
    private final class_1792 material;
    private final class_5251 color;
    private final int ordinal;
    private final int weight;
    private final float quality;
    private final List<LootRule> rules;

    private LootRarity(class_5251 color, class_1792 material, int ordinal, int weight, float quality, List<LootRule> rules) {
        this.color = color;
        this.material = material;
        this.ordinal = ordinal;
        this.weight = weight;
        this.quality = quality;
        this.rules = rules;
    }

    public class_1792 getMaterial() {
        return this.material;
    }

    public class_5251 getColor() {
        return this.color;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public List<LootRule> getRules() {
        return this.rules;
    }

    public LootRarity next() {
        return (LootRarity)RarityRegistry.next((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(this)).get();
    }

    public LootRarity prev() {
        return (LootRarity)RarityRegistry.prev((DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(this)).get();
    }

    public boolean isAtMost(LootRarity other) {
        return this.ordinal() <= other.ordinal();
    }

    public boolean isAtLeast(LootRarity other) {
        return this.ordinal() >= other.ordinal();
    }

    public static LootRarity min(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal <= b.ordinal ? a : b;
    }

    public static LootRarity max(LootRarity a, @Nullable LootRarity b) {
        if (b == null) {
            return a;
        }
        return a.ordinal >= b.ordinal ? a : b;
    }

    public LootRarity clamp(@Nullable LootRarity lowerBound, @Nullable LootRarity upperBound) {
        return LootRarity.max(LootRarity.min(this, upperBound), lowerBound);
    }

    public class_2561 toComponent() {
        return class_2561.method_43471((String)("rarity." + RarityRegistry.INSTANCE.getKey(this))).method_27696(class_2583.field_24360.method_27703(this.color));
    }

    public String toString() {
        return "LootRarity{" + RarityRegistry.INSTANCE.getKey(this) + "}";
    }

    @Override
    public int compareTo(LootRarity o) {
        return Integer.compare(this.ordinal, o.ordinal);
    }

    public Codec<? extends LootRarity> getCodec() {
        return LOAD_CODEC;
    }

    public static LootRarity random(class_5819 rand, float luck) {
        return (LootRarity)RarityRegistry.INSTANCE.getRandomItem(rand, luck);
    }

    public static LootRarity random(class_5819 rand, float luck, @Nullable RarityClamp clamp) {
        LootRarity rarity = LootRarity.random(rand, luck);
        return clamp == null ? rarity : clamp.clamp(rarity);
    }

    public static <T> Codec<Map<LootRarity, T>> mapCodec(Codec<T> codec) {
        return Codec.unboundedMap(CODEC, codec);
    }

    public record LootRule(AffixType type, float chance, @Nullable LootRule backup) {
        public static final Codec<LootRule> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.enumCodec(AffixType.class).fieldOf("type").forGetter(LootRule::type), (App)Codec.FLOAT.fieldOf("chance").forGetter(LootRule::chance), (App)PlaceboCodecs.nullableField((Codec)class_5699.method_39240(() -> CODEC), (String)"backup").forGetter(rule -> Optional.ofNullable(rule.backup()))).apply((Applicative)inst, LootRule::new));
        private static Random jRand = new Random();

        public LootRule(AffixType type, float chance) {
            this(type, chance, Optional.empty());
        }

        public LootRule(AffixType type, float chance, Optional<LootRule> backup) {
            this(type, chance, (LootRule)backup.orElse(null));
        }

        public void execute(class_1799 stack, LootRarity rarity, Set<DynamicHolder<Affix>> currentAffixes, MutableInt sockets, class_5819 rand) {
            if (this.type == AffixType.DURABILITY) {
                return;
            }
            if (rand.method_43057() <= this.chance) {
                if (this.type == AffixType.SOCKET) {
                    sockets.add(1);
                    return;
                }
                List available = AffixHelper.byType(this.type).stream().filter(a -> ((Affix)a.get()).canApplyTo(stack, LootCategory.forItem(stack), rarity) && !currentAffixes.contains(a)).collect(Collectors.toList());
                if (available.size() == 0) {
                    if (this.backup != null) {
                        this.backup.execute(stack, rarity, currentAffixes, sockets, rand);
                    } else {
                        AdventureModule.LOGGER.error("Failed to execute LootRule {}/{}/{}/{}!", (Object)class_7923.field_41178.method_10221((Object)stack.method_7909()), (Object)RarityRegistry.INSTANCE.getKey(rarity), (Object)this.type, (Object)Float.valueOf(this.chance));
                    }
                    return;
                }
                jRand.setSeed(rand.method_43055());
                Collections.shuffle(available, jRand);
                currentAffixes.add((DynamicHolder<Affix>)((DynamicHolder)available.get(0)));
            }
        }
    }
}

