/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.compat;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.objects.FilteringShelfBlock;
import dev.shadowsoffire.apotheosis.mixin.accessors.ChiseledBookShelfBlockAccessor;
import dev.shadowsoffire.apotheosis.util.CommonTooltipUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class EnchWTHITPlugin
implements IWailaPlugin,
IBlockComponentProvider {
    public static DecimalFormat dfCommas = new DecimalFormat("##.##");

    public void register(IRegistrar reg) {
        if (!Apotheosis.enableEnch) {
            return;
        }
        reg.addComponent((IBlockComponentProvider)this, TooltipPosition.BODY, class_2248.class);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!Apotheosis.enableEnch) {
            return;
        }
        if (accessor.getBlock() instanceof class_2199) {
            class_2487 tag = accessor.getData().raw();
            Map enchants = class_1890.method_22445((class_2499)tag.method_10554("enchantments", 10));
            for (Map.Entry e : enchants.entrySet()) {
                tooltip.addLine(((class_1887)e.getKey()).method_8179(((Integer)e.getValue()).intValue()));
            }
        }
        CommonTooltipUtil.appendBlockStats(accessor.getWorld(), accessor.getBlockState(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).addLine(arg_0));
        if (accessor.getBlock() == class_2246.field_10485) {
            CommonTooltipUtil.appendTableStats(accessor.getWorld(), accessor.getPosition(), arg_0 -> ((ITooltip)tooltip).addLine(arg_0));
        }
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF) {
            this.handleFilteringShelf(tooltip, accessor);
        }
    }

    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        if (!Apotheosis.enableEnch) {
            return super.getIcon(accessor, config);
        }
        if (accessor.getBlock() == Ench.Blocks.FILTERING_SHELF) {
            return new ItemComponent(accessor.getStack());
        }
        return super.getIcon(accessor, config);
    }

    public void handleFilteringShelf(ITooltip tooltip, IBlockAccessor accessor) {
        class_2586 class_25862 = accessor.getBlockEntity();
        if (class_25862 instanceof FilteringShelfBlock.FilteringShelfTile) {
            FilteringShelfBlock.FilteringShelfTile tile = (FilteringShelfBlock.FilteringShelfTile)class_25862;
            tooltip.getLine(new class_2960("chiseled_bookshelf"));
            Optional<class_241> optional = ChiseledBookShelfBlockAccessor.callGetRelativeHitCoordinatesForBlockFace(accessor.getBlockHitResult(), (class_2350)accessor.getBlockState().method_11654((class_2769)class_2383.field_11177));
            if (optional.isEmpty()) {
                return;
            }
            int slot = ChiseledBookShelfBlockAccessor.callGetHitSlot(optional.get());
            class_1799 stack = tile.method_5438(slot);
            if (stack.method_7960()) {
                return;
            }
            tooltip.addLine(class_5244.field_39003);
            tooltip.addLine().with((ITooltipComponent)new ItemComponent(stack)).with((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)this.humanReadableNumber(stack.method_7947(), "", false)).method_27693("\u00d7 ").method_10852(stack.method_7964())));
            if (stack.method_7969() != null && stack.method_7969().method_10545("StoredEnchantments")) {
                ArrayList list = new ArrayList();
                class_1799.method_17870(list, (class_2499)class_1772.method_7806((class_1799)stack));
                for (class_2561 c : list) {
                    tooltip.addLine((class_2561)class_2561.method_43470((String)" - ").method_10852(c));
                }
            }
        }
    }

    public String humanReadableNumber(double number, String unit, boolean milli) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        if (number < 1000.0) {
            sb.append(dfCommas.format(number));
            if (milli && number != 0.0) {
                sb.append('m');
            }
        } else {
            int exp = (int)(Math.log10(number) / 3.0);
            if (exp > 7) {
                exp = 7;
            }
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(dfCommas.format(number / Math.pow(1000.0, exp)));
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }
}

