/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import io.github.fabricators_of_create.porting_lib.enchant.EnchantmentBonusBlock;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EnchantingStatRegistry
extends DynamicRegistry<BlockStats> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final EnchantingStatRegistry INSTANCE = new EnchantingStatRegistry();
    private final Map<class_2248, Stats> statsPerBlock = new HashMap<class_2248, Stats>();
    private float absoluteMaxEterna = 50.0f;

    protected EnchantingStatRegistry() {
        super(EnchModule.LOGGER, "enchanting_stats", true, false);
    }

    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(Apotheosis.loc("enchanting_stats"), BlockStats.CODEC);
    }

    protected void beginReload() {
        super.beginReload();
        this.statsPerBlock.clear();
    }

    protected void onReload() {
        super.onReload();
        for (BlockStats bStats : this.registry.values()) {
            bStats.blocks.forEach(b -> this.statsPerBlock.put((class_2248)b, bStats.stats));
        }
        this.computeAbsoluteMaxEterna();
    }

    public static float getEterna(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).eterna;
        }
        if (state instanceof EnchantmentBonusBlock) {
            EnchantmentBonusBlock enchantingBlock = (EnchantmentBonusBlock)state;
            return enchantingBlock.getEnchantPowerBonus(state, (class_4538)world, pos);
        }
        if (state.method_27852(class_2246.field_10504) || state.method_26164(class_3481.field_44472) || state.method_26164(ConventionalBlockTags.BOOKSHELVES)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getMaxEterna(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).maxEterna;
        }
        if (block instanceof IEnchantingBlock) {
            IEnchantingBlock enchantingBlock = (IEnchantingBlock)block;
            return enchantingBlock.getMaxEnchantingPower(state, (class_4538)world, pos);
        }
        if (state.method_27852(class_2246.field_10504) || state.method_26164(class_3481.field_44472) || state.method_26164(ConventionalBlockTags.BOOKSHELVES)) {
            return 15.0f;
        }
        return 0.0f;
    }

    public static float getQuanta(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).quanta;
        }
        return ((IEnchantingBlock)block).getQuantaBonus(state, (class_4538)world, pos);
    }

    public static float getArcana(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).arcana;
        }
        return ((IEnchantingBlock)block).getArcanaBonus(state, (class_4538)world, pos);
    }

    public static float getQuantaRectification(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).rectification;
        }
        return ((IEnchantingBlock)block).getQuantaRectification(state, (class_4538)world, pos);
    }

    public static int getBonusClues(class_2680 state, class_1937 world, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (EnchantingStatRegistry.INSTANCE.statsPerBlock.containsKey(block)) {
            return EnchantingStatRegistry.INSTANCE.statsPerBlock.get((Object)block).clues;
        }
        return ((IEnchantingBlock)block).getBonusClues(state, (class_4538)world, pos);
    }

    public static float getAbsoluteMaxEterna() {
        return EnchantingStatRegistry.INSTANCE.absoluteMaxEterna;
    }

    private void computeAbsoluteMaxEterna() {
        this.absoluteMaxEterna = this.registry.values().stream().max(Comparator.comparingDouble((ToDoubleFunction<BlockStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$computeAbsoluteMaxEterna$1(dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry$BlockStats ), (Ldev/shadowsoffire/apotheosis/ench/table/EnchantingStatRegistry$BlockStats;)D)())).get().stats.maxEterna;
    }

    private static /* synthetic */ double lambda$computeAbsoluteMaxEterna$1(BlockStats s) {
        return s.stats.maxEterna;
    }

    public static class BlockStats
    implements CodecProvider<BlockStats> {
        public static Codec<BlockStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.list((Codec)class_7923.field_41175.method_39673()), (String)"blocks", Collections.emptyList()).forGetter(bs -> bs.blocks), (App)PlaceboCodecs.nullableField((Codec)class_6862.method_40090((class_5321)class_7924.field_41254), (String)"tag").forGetter(bs -> Optional.empty()), (App)PlaceboCodecs.nullableField((Codec)class_7923.field_41175.method_39673(), (String)"block").forGetter(bs -> Optional.empty()), (App)Stats.CODEC.fieldOf("stats").forGetter(bs -> bs.stats)).apply((Applicative)inst, BlockStats::new));
        public final List<class_2248> blocks = new ArrayList<class_2248>();
        public final Stats stats;

        public BlockStats(List<class_2248> blocks, Optional<class_6862<class_2248>> tag, Optional<class_2248> block, Stats stats) {
            Map registryTags;
            Map allTags;
            if (!blocks.isEmpty()) {
                this.blocks.addAll(blocks);
            }
            if (tag.isPresent() && (allTags = (Map)ResourceConditionsImpl.LOADED_TAGS.get()) != null && (registryTags = (Map)allTags.get(class_5321.method_29180((class_2960)new class_2960("minecraft:block")))) != null) {
                this.blocks.addAll(((Collection)registryTags.get(tag.get().comp_327())).stream().map(class_6880::comp_349).toList());
            }
            block.ifPresent(this.blocks::add);
            this.stats = stats;
        }

        public Codec<? extends BlockStats> getCodec() {
            return CODEC;
        }
    }

    public record Stats(float maxEterna, float eterna, float quanta, float arcana, float rectification, int clues) {
        public static Codec<Stats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"maxEterna", (Object)Float.valueOf(15.0f)).forGetter(Stats::maxEterna), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"eterna", (Object)Float.valueOf(0.0f)).forGetter(Stats::eterna), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"quanta", (Object)Float.valueOf(0.0f)).forGetter(Stats::quanta), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"arcana", (Object)Float.valueOf(0.0f)).forGetter(Stats::arcana), (App)PlaceboCodecs.nullableField((Codec)Codec.FLOAT, (String)"rectification", (Object)Float.valueOf(0.0f)).forGetter(Stats::rectification), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"clues", (Object)0).forGetter(Stats::clues)).apply((Applicative)inst, Stats::new));

        public void write(class_2540 buf) {
            buf.writeFloat(this.maxEterna);
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
        }

        public static Stats read(class_2540 buf) {
            return new Stats(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte());
        }
    }
}

