/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.common.collect.Lists;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.EnchantmentInfo;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.IEnchantableItem;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingTableBehaviorEnchantment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_7923;

public class RealEnchantmentHelper {
    public static int getEnchantmentCost(class_5819 rand, int num, float eterna, class_1799 stack) {
        int level = Math.round(eterna * 2.0f);
        if (num == 2) {
            return level;
        }
        float lowBound = 0.6f - 0.4f * (float)(1 - num);
        float highBound = 0.8f - 0.4f * (float)(1 - num);
        return Math.max(1, Math.round((float)level * class_3532.method_15344((class_5819)rand, (float)lowBound, (float)highBound)));
    }

    public static List<class_1889> selectEnchantment(class_5819 rand, class_1799 stack, int level, float quanta, float arcana, float rectification, boolean treasure, Set<class_1887> blacklist) {
        ArrayList chosenEnchants = Lists.newArrayList();
        int enchantability = stack.method_7909().method_7837();
        int srcLevel = level;
        if (Apotheosis.enableDebug) {
            EnchModule.LOGGER.info("enchantability {}, level {}", (Object)enchantability, (Object)level);
        }
        if (enchantability > 0) {
            float quantaFactor = 1.0f + RealEnchantmentHelper.getQuantaFactor(rand, quanta, rectification);
            level = class_3532.method_15340((int)Math.round((float)level * quantaFactor), (int)1, (int)((int)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f)));
            ApothEnchantmentMenu.Arcana arcanaVals = ApothEnchantmentMenu.Arcana.getForThreshold(arcana);
            List<class_1889> allEnchants = RealEnchantmentHelper.getAvailableEnchantmentResults(level, stack, treasure, blacklist);
            Map enchants = class_1890.method_8222((class_1799)stack);
            allEnchants.removeIf(e -> enchants.containsKey(e.field_9093));
            List<ArcanaEnchantmentData> possibleEnchants = allEnchants.stream().map(d -> new ArcanaEnchantmentData(arcanaVals, (class_1889)d)).collect(Collectors.toList());
            if (!possibleEnchants.isEmpty()) {
                chosenEnchants.add(((ArcanaEnchantmentData)((Object)class_6011.method_34986((class_5819)rand, possibleEnchants).get())).data);
                RealEnchantmentHelper.removeIncompatible(possibleEnchants, (class_1889)class_156.method_20793((List)chosenEnchants));
                if (arcana >= 25.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)class_6011.method_34986((class_5819)rand, possibleEnchants).get())).data);
                    RealEnchantmentHelper.removeIncompatible(possibleEnchants, (class_1889)class_156.method_20793((List)chosenEnchants));
                }
                if (arcana >= 75.0f && !possibleEnchants.isEmpty()) {
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)class_6011.method_34986((class_5819)rand, possibleEnchants).get())).data);
                }
                int randomBound = 50;
                if (level > 45) {
                    level = (int)((float)srcLevel * 1.15f);
                }
                while (rand.method_43048(randomBound) <= level) {
                    if (!chosenEnchants.isEmpty()) {
                        RealEnchantmentHelper.removeIncompatible(possibleEnchants, (class_1889)class_156.method_20793((List)chosenEnchants));
                    }
                    if (possibleEnchants.isEmpty()) break;
                    chosenEnchants.add(((ArcanaEnchantmentData)((Object)class_6011.method_34986((class_5819)rand, possibleEnchants).get())).data);
                    level /= 2;
                }
            }
        }
        return ((IEnchantableItem)stack.method_7909()).selectEnchantments(chosenEnchants, rand, stack, srcLevel, quanta, arcana, treasure);
    }

    public static void removeIncompatible(List<ArcanaEnchantmentData> list, class_1889 data) {
        Iterator<ArcanaEnchantmentData> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (data.field_9093.method_8188(iterator.next().data.field_9093)) continue;
            iterator.remove();
        }
    }

    public static List<class_1889> getAvailableEnchantmentResults(int power, class_1799 stack, boolean allowTreasure, Set<class_1887> blacklist) {
        ArrayList<class_1889> list = new ArrayList<class_1889>();
        IEnchantableItem item = (IEnchantableItem)stack.method_7909();
        allowTreasure = item.isTreasureAllowed(stack, allowTreasure);
        block0: for (class_1887 enchantment : class_7923.field_41176) {
            class_1792 class_17922;
            EnchantmentInfo info = EnchModule.getEnchInfo(enchantment);
            if (info.isTreasure() && !allowTreasure || !info.isDiscoverable()) continue;
            boolean special = false;
            if (enchantment instanceof CustomEnchantingTableBehaviorEnchantment) {
                CustomEnchantingTableBehaviorEnchantment customEnch = (CustomEnchantingTableBehaviorEnchantment)enchantment;
                special = customEnch.canApplyAtEnchantingTable(stack);
            }
            if ((class_17922 = stack.method_7909()) instanceof CustomEnchantingBehaviorItem) {
                CustomEnchantingBehaviorItem customItem = (CustomEnchantingBehaviorItem)class_17922;
                special = customItem.canApplyAtEnchantingTable(stack, enchantment);
            }
            if (blacklist.contains(enchantment) || !special && !enchantment.method_8192(stack) && !item.forciblyAllowsTableEnchantment(stack, enchantment)) continue;
            for (int level = info.getMaxLevel(); level > enchantment.method_8187() - 1; --level) {
                if (power < info.getMinPower(level) || power < info.getMaxPower(level) && level != enchantment.method_8187()) continue;
                list.add(new class_1889(enchantment, level));
                continue block0;
            }
        }
        return list;
    }

    private static void checkSpellEngine(class_1799 stack, List<class_1889> currentEntries) {
        if (stack.method_31574(class_1802.field_8529)) {
            return;
        }
        ArrayList<class_1889> toRemove = new ArrayList<class_1889>();
        for (class_1889 entry : currentEntries) {
            if (entry.field_9093.method_8192(stack)) continue;
            toRemove.add(entry);
        }
        if (Apotheosis.enableDebug) {
            toRemove.forEach(ench -> EnchModule.LOGGER.info("removing for spell power {}", (Object)ench.field_9093.toString()));
        }
        currentEntries.removeAll(toRemove);
    }

    public static float getQuantaFactor(class_5819 rand, float quanta, float rectification) {
        float rectPercent;
        float gaussian = (float)rand.method_43059();
        float factor = class_3532.method_15363((float)(gaussian / 3.0f), (float)-1.0f, (float)1.0f);
        if (factor < (rectPercent = rectification / 100.0f) - 1.0f) {
            factor = class_3532.method_15344((class_5819)rand, (float)(rectPercent - 1.0f), (float)1.0f);
        }
        return quanta * factor / 100.0f;
    }

    public static class ArcanaEnchantmentData
    extends class_6008.class_6009 {
        class_1889 data;

        public ArcanaEnchantmentData(ApothEnchantmentMenu.Arcana arcana, class_1889 data) {
            super(arcana.getRarities()[data.field_9093.method_8186().ordinal()]);
            this.data = data;
        }
    }
}

