/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.spawn.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.mixin.accessors.BaseSpawnerAccessor;
import dev.shadowsoffire.apotheosis.spawn.SpawnerModule;
import dev.shadowsoffire.apotheosis.spawn.modifiers.SpawnerStat;
import dev.shadowsoffire.apotheosis.spawn.modifiers.StatModifier;
import dev.shadowsoffire.apotheosis.spawn.spawner.IBaseSpawner;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2636;
import net.minecraft.class_3532;
import net.minecraft.class_5244;

public class SpawnerStats {
    public static final Map<String, SpawnerStat<?>> REGISTRY = new LinkedHashMap();
    public static final SpawnerStat<Short> MIN_DELAY = SpawnerStats.register(new ShortStat("min_delay", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getMinSpawnDelay(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setMinSpawnDelay(v.shortValue())));
    public static final SpawnerStat<Short> MAX_DELAY = SpawnerStats.register(new ShortStat("max_delay", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getMaxSpawnDelay(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setMaxSpawnDelay(v.shortValue())));
    public static final SpawnerStat<Short> SPAWN_COUNT = SpawnerStats.register(new ShortStat("spawn_count", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getSpawnCount(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setSpawnCount(v.shortValue())));
    public static final SpawnerStat<Short> MAX_NEARBY_ENTITIES = SpawnerStats.register(new ShortStat("max_nearby_entities", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getMaxNearbyEntities(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setMaxNearbyEntities(v.shortValue())));
    public static final SpawnerStat<Short> REQ_PLAYER_RANGE = SpawnerStats.register(new ShortStat("req_player_range", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getRequiredPlayerRange(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setRequiredPlayerRange(v.shortValue())));
    public static final SpawnerStat<Short> SPAWN_RANGE = SpawnerStats.register(new ShortStat("spawn_range", s -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).getSpawnRange(), (s, v) -> ((BaseSpawnerAccessor)s.zenith$getSpawner()).setSpawnRange(v.shortValue())));
    public static final SpawnerStat<Boolean> IGNORE_PLAYERS = SpawnerStats.register(new BoolStat("ignore_players", IBaseSpawner::zenith$getIgnorePlayers, IBaseSpawner::zenith$setIgnoresPlayers));
    public static final SpawnerStat<Boolean> IGNORE_CONDITIONS = SpawnerStats.register(new BoolStat("ignore_conditions", IBaseSpawner::zenith$getIgnoresConditions, IBaseSpawner::zenith$setIgnoresConditions));
    public static final SpawnerStat<Boolean> REDSTONE_CONTROL = SpawnerStats.register(new BoolStat("redstone_control", IBaseSpawner::zenith$getRedstoneControl, IBaseSpawner::zenith$setRedstoneControl));
    public static final SpawnerStat<Boolean> IGNORE_LIGHT = SpawnerStats.register(new BoolStat("ignore_light", IBaseSpawner::zenith$getIgnoreLight, IBaseSpawner::zenith$setIgnoreLight));
    public static final SpawnerStat<Boolean> NO_AI = SpawnerStats.register(new BoolStat("no_ai", IBaseSpawner::zenith$getNoAi, IBaseSpawner::zenith$setNoAi));
    public static final SpawnerStat<Boolean> SILENT = SpawnerStats.register(new BoolStat("silent", IBaseSpawner::zenith$getSilent, IBaseSpawner::zenith$setSilent));
    public static final SpawnerStat<Boolean> BABY = SpawnerStats.register(new BoolStat("baby", IBaseSpawner::zenith$getBaby, IBaseSpawner::zenith$setBaby));

    public static void generateTooltip(class_2636 tile, Consumer<class_2561> list) {
        for (SpawnerStat<?> stat : REGISTRY.values()) {
            class_2561 comp = stat.getTooltip((IBaseSpawner)tile);
            if (comp.getString().isEmpty()) continue;
            list.accept(comp);
        }
    }

    private static <T extends SpawnerStat<?>> T register(T t) {
        REGISTRY.put(t.getId(), t);
        return t;
    }

    private static class ShortStat
    extends Base<Short> {
        public static final Codec<Short> BOUNDS_CODEC = Codec.intRange((int)-1, (int)Short.MAX_VALUE).xmap(Integer::shortValue, Short::intValue);
        private final Codec<StatModifier<Short>> modifierCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.SHORT.fieldOf("value").forGetter(StatModifier::value), (App)BOUNDS_CODEC.fieldOf("min").forGetter(StatModifier::min), (App)BOUNDS_CODEC.fieldOf("max").forGetter(StatModifier::max)).apply((Applicative)inst, (value, min, max) -> new StatModifier<Short>(this, (Short)value, min == -1 ? (short)0 : min, max == -1 ? (short)Short.MAX_VALUE : (short)max)));

        private ShortStat(String id, Function<IBaseSpawner, Integer> getter, BiConsumer<IBaseSpawner, Short> setter) {
            super(id, (IBaseSpawner tile) -> ((Integer)getter.apply((IBaseSpawner)tile)).shortValue(), setter);
        }

        @Override
        public Codec<StatModifier<Short>> getModifierCodec() {
            return this.modifierCodec;
        }

        @Override
        public class_2561 getTooltip(IBaseSpawner spawner) {
            return SpawnerModule.concat(this.name(), this.getValue(spawner));
        }

        @Override
        public boolean apply(Short value, Short min, Short max, IBaseSpawner spawner) {
            short old = (Short)this.getter.apply(spawner);
            this.setter.accept(spawner, (short)class_3532.method_15340((int)(old + value), (int)min.shortValue(), (int)max.shortValue()));
            return old != (Short)this.getter.apply(spawner);
        }
    }

    private static class BoolStat
    extends Base<Boolean> {
        private final Codec<StatModifier<Boolean>> modifierCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.fieldOf("value").forGetter(StatModifier::value)).apply((Applicative)inst, value -> new StatModifier<Boolean>(this, (Boolean)value, false, true)));

        private BoolStat(String id, Function<IBaseSpawner, Boolean> getter, BiConsumer<IBaseSpawner, Boolean> setter) {
            super(id, getter, setter);
        }

        @Override
        public Codec<StatModifier<Boolean>> getModifierCodec() {
            return this.modifierCodec;
        }

        @Override
        public class_2561 getTooltip(IBaseSpawner spawner) {
            return (Boolean)this.getValue(spawner) != false ? this.name().method_27692(class_124.field_1077) : class_5244.field_39003;
        }

        @Override
        public boolean apply(Boolean value, Boolean min, Boolean max, IBaseSpawner spawner) {
            boolean old = (Boolean)this.getter.apply(spawner);
            this.setter.accept(spawner, value);
            return old != (Boolean)this.getter.apply(spawner);
        }
    }

    private static abstract class Base<T>
    implements SpawnerStat<T> {
        protected final String id;
        protected final Function<IBaseSpawner, T> getter;
        protected final BiConsumer<IBaseSpawner, T> setter;

        private Base(String id, Function<IBaseSpawner, T> getter, BiConsumer<IBaseSpawner, T> setter) {
            this.id = id;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public T getValue(IBaseSpawner spawner) {
            return this.getter.apply(spawner);
        }
    }
}

