/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Predicates;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.cca.BossComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantmentMenu;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5131;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class CommonTooltipUtil {
    public static void appendBossData(class_1937 level, class_1309 entity, Consumer<class_2561> tooltip) {
        DynamicHolder<LootRarity> rarity = RarityRegistry.byLegacyId(((BossComponent)ZenithComponents.BOSS_DATA.get((Object)entity)).getRarity());
        if (!rarity.isBound()) {
            return;
        }
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.boss", (Object[])new Object[]{((LootRarity)rarity.get()).toComponent()}).method_27692(class_124.field_1080));
        tooltip.accept(class_5244.field_39003);
        tooltip.accept((class_2561)class_2561.method_43471((String)"info.zenith.boss_modifiers").method_27692(class_124.field_1080));
        class_5131 map = entity.method_6127();
        class_7923.field_41190.method_10220().map(arg_0 -> ((class_5131)map).method_26842(arg_0)).filter((Predicate<class_1324>)Predicates.notNull()).forEach(inst -> {
            for (class_1322 modif : inst.method_6195()) {
                if (!modif.method_6185().startsWith("placebo_random_modifier_")) continue;
                tooltip.accept((class_2561)IFormattableAttribute.toComponent((class_1320)inst.method_6198(), (class_1322)modif, (class_1836)AttributesLib.getTooltipFlag()));
            }
        });
    }

    public static void appendBlockStats(class_1937 world, class_2680 state, class_2338 pos, Consumer<class_2561> tooltip) {
        Set<class_1887> blacklist;
        float maxEterna = EnchantingStatRegistry.getMaxEterna(state, world, pos);
        float eterna = EnchantingStatRegistry.getEterna(state, world, pos);
        float quanta = EnchantingStatRegistry.getQuanta(state, world, pos);
        float arcana = EnchantingStatRegistry.getArcana(state, world, pos);
        float rectification = EnchantingStatRegistry.getQuantaRectification(state, world, pos);
        int clues = EnchantingStatRegistry.getBonusClues(state, world, pos);
        boolean treasure = ((IEnchantingBlock)state.method_26204()).allowsTreasure(state, (class_4538)world, pos);
        if (eterna != 0.0f || quanta != 0.0f || arcana != 0.0f || rectification != 0.0f || clues != 0) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"info.zenith.ench_stats").method_27692(class_124.field_1065));
        }
        if (eterna != 0.0f) {
            if (eterna > 0.0f) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.eterna.p", (Object[])new Object[]{String.format("%.2f", Float.valueOf(eterna)), String.format("%.2f", Float.valueOf(maxEterna))}).method_27692(class_124.field_1060));
            } else {
                tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.eterna", (Object[])new Object[]{String.format("%.2f", Float.valueOf(eterna))}).method_27692(class_124.field_1060));
            }
        }
        if (quanta != 0.0f) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("info.zenith.quanta" + (quanta > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(quanta))}).method_27692(class_124.field_1061));
        }
        if (arcana != 0.0f) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("info.zenith.arcana" + (arcana > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(arcana))}).method_27692(class_124.field_1064));
        }
        if (rectification != 0.0f) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("info.zenith.rectification" + (rectification > 0.0f ? ".p" : "")), (Object[])new Object[]{String.format("%.2f", Float.valueOf(rectification))}).method_27692(class_124.field_1054));
        }
        if (clues != 0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)("info.zenith.clues" + (clues > 0 ? ".p" : "")), (Object[])new Object[]{String.format("%d", clues)}).method_27692(class_124.field_1062));
        }
        if (treasure) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"info.zenith.allows_treasure").method_27692(class_124.field_1065));
        }
        if ((blacklist = ((IEnchantingBlock)state.method_26204()).getBlacklistedEnchantments(state, (class_4538)world, pos)).size() > 0) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"info.zenith.filter").method_27694(s -> s.method_36139(5812428)));
            for (class_1887 e : blacklist) {
                class_5250 name = (class_5250)e.method_8179(1);
                name.method_10855().clear();
                name.method_27694(s -> s.method_36139(5798058));
                tooltip.accept((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)name).method_27694(s -> s.method_36139(5798058)));
            }
        }
    }

    public static void appendTableStats(class_1937 world, class_2338 pos, Consumer<class_2561> tooltip) {
        ApothEnchantmentMenu.TableStats stats = ApothEnchantmentMenu.gatherStats(world, pos, 0);
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.eterna.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(stats.eterna())), String.format("%.2f", Float.valueOf(EnchantingStatRegistry.getAbsoluteMaxEterna()))}).method_27692(class_124.field_1060));
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.quanta.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.quanta())))}).method_27692(class_124.field_1061));
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.arcana.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Math.min(100.0f, stats.arcana())))}).method_27692(class_124.field_1064));
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.rectification.t", (Object[])new Object[]{String.format("%.2f", Float.valueOf(class_3532.method_15363((float)stats.rectification(), (float)-100.0f, (float)100.0f)))}).method_27692(class_124.field_1054));
        tooltip.accept((class_2561)class_2561.method_43469((String)"info.zenith.clues.t", (Object[])new Object[]{String.format("%d", stats.clues())}).method_27692(class_124.field_1062));
    }
}

