/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.gson.JsonObject;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class GemIngredient
implements CustomIngredient {
    protected final DynamicHolder<LootRarity> rarity;
    protected class_1799[] items;

    public GemIngredient(DynamicHolder<LootRarity> rarity) {
        this.rarity = rarity;
    }

    public boolean test(class_1799 stack) {
        DynamicHolder<LootRarity> rarity = AffixHelper.getRarity(stack);
        return stack.method_7909() == Adventure.Items.GEM && rarity.isBound() && rarity == this.rarity;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.items == null) {
            Collection gems = GemRegistry.INSTANCE.getValues();
            if (gems.size() == 0) {
                return List.of(new class_1799[0]);
            }
            this.items = new class_1799[gems.size()];
            int i = 0;
            for (Gem g : GemRegistry.INSTANCE.getValues()) {
                this.items[i++] = GemRegistry.createGemStack(g, (LootRarity)this.rarity.get());
            }
        }
        return List.of(this.items);
    }

    public boolean requiresTesting() {
        return false;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public LootRarity getRarity() {
        return (LootRarity)this.rarity.get();
    }

    public static class Serializer
    implements CustomIngredientSerializer<GemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public class_2960 getIdentifier() {
            return Apotheosis.loc("gem");
        }

        public GemIngredient read(JsonObject json) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(new class_2960(class_3518.method_15265((JsonObject)json, (String)"rarity")));
            return new GemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public void write(JsonObject json, GemIngredient ingredient) {
        }

        public GemIngredient read(class_2540 buf) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(buf.method_10810());
            return new GemIngredient((DynamicHolder<LootRarity>)rarity);
        }

        public void write(class_2540 buffer, GemIngredient ingredient) {
            buffer.method_10812(ingredient.rarity.getId());
        }
    }
}

