/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.village.wanderer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.shadowsoffire.apotheosis.village.util.BasicItemListing;
import dev.shadowsoffire.apotheosis.village.wanderer.BasicItemListingAdapter;
import dev.shadowsoffire.apotheosis.village.wanderer.WandererTradesRegistry;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.json.ItemAdapter;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3853;

public class WandererReplacements {
    public static boolean clearNormTrades = false;
    public static boolean clearRareTrades = false;
    public static boolean undergroundTrader = true;
    public static int wandererMaxChance = 101;
    public static int wandererRngCoeff = 2;
    public static int despawnDelay = 24000;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BasicItemListing.class, (Object)BasicItemListingAdapter.INSTANCE).registerTypeAdapter(class_1799.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(class_2487.class, (Object)NBTAdapter.INSTANCE).create();

    public static void setup() {
        WandererTradesRegistry.INSTANCE.register();
    }

    public static void replaceWandererArrays(List<class_3853.class_1652> generic, List<class_3853.class_1652> rare) {
        if (clearNormTrades) {
            generic.clear();
        }
        if (clearRareTrades) {
            rare.clear();
        }
        generic.addAll(WandererTradesRegistry.INSTANCE.getNormalTrades());
        rare.addAll(WandererTradesRegistry.INSTANCE.getRareTrades());
    }

    public static void load(Configuration cfg) {
        clearNormTrades = cfg.getBoolean("Clear Generic Trades", "wanderer", clearNormTrades, "If the generic trade list will be cleared before datapack loaded trades are added.\nServer-authoritative.");
        clearRareTrades = cfg.getBoolean("Clear Rare Trades", "wanderer", clearRareTrades, "If the rare trade list will be cleared before datapack loaded trades are added.\nServer-authoritative.");
        undergroundTrader = cfg.getBoolean("Underground Trader", "wanderer", undergroundTrader, "If the Wandering Trader can attempt to spawn underground.\nServer-authoritative.");
    }
}

