/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import me.shedaniel.rareice.blocks.RareIceBlock;
import me.shedaniel.rareice.blocks.entities.RareIceBlockEntity;
import me.shedaniel.rareice.world.gen.feature.RareIceConfig;
import me.shedaniel.rareice.world.gen.feature.RareIceCountPlacement;
import me.shedaniel.rareice.world.gen.feature.RareIceFeature;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6798;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RareIce
implements ModInitializer {
    public static final class_2248 RARE_ICE_BLOCK = new RareIceBlock(FabricBlockSettings.copyOf((class_4970)class_2246.field_10295).method_26235((state, world, pos, type) -> type == class_1299.field_6042));
    public static final class_2591<RareIceBlockEntity> RARE_ICE_BLOCK_ENTITY_TYPE = FabricBlockEntityTypeBuilder.create(RareIceBlockEntity::new, (class_2248[])new class_2248[]{RARE_ICE_BLOCK}).build(null);
    public static final class_3031<RareIceConfig> RARE_ICE_FEATURE = new RareIceFeature(RareIceConfig.CODEC);
    public static final class_6798<RareIceCountPlacement> COUNT_PLACEMENT = () -> RareIceCountPlacement.CODEC;
    public static boolean allowInsertingItemsToIce = true;
    public static int probabilityOfRareIce = 3;

    private static void loadConfig(Path file) {
        allowInsertingItemsToIce = true;
        probabilityOfRareIce = 3;
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Properties properties = new Properties();
                properties.load(Files.newBufferedReader(file));
                allowInsertingItemsToIce = properties.getProperty("allowInsertingItemsToIce", "true").equals("true");
                probabilityOfRareIce = Integer.parseInt(properties.getProperty("probabilityOfRareIce", "3"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RareIce.saveConfig(file);
    }

    private static void saveConfig(Path file) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Properties properties = new Properties();
            properties.setProperty("allowInsertingItemsToIce", String.valueOf(allowInsertingItemsToIce));
            properties.setProperty("probabilityOfRareIce", String.valueOf(probabilityOfRareIce));
            properties.store(Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE), "Rare Ice Configuration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onInitialize() {
        RareIce.loadConfig(FabricLoader.getInstance().getConfigDir().resolve("rare-ice.properties"));
        class_2378.method_10230((class_2378)class_7923.field_41148, (class_2960)new class_2960("rare-ice", "rare_ice_count"), COUNT_PLACEMENT);
        class_2378.method_10230((class_2378)class_7923.field_41144, (class_2960)new class_2960("rare-ice", "rare_ice"), RARE_ICE_FEATURE);
        class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("rare-ice", "rare_ice"), RARE_ICE_BLOCK_ENTITY_TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("rare-ice", "rare_ice"), (Object)RARE_ICE_BLOCK);
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!allowInsertingItemsToIce) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            if (player == null || player.method_5715()) {
                return class_1269.field_5811;
            }
            if (state.method_26204() == class_2246.field_10295 || state.method_26204() == RARE_ICE_BLOCK) {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity == null) {
                    world.method_8501(pos, RARE_ICE_BLOCK.method_9564());
                    blockEntity = world.method_8321(pos);
                }
                if (blockEntity instanceof RareIceBlockEntity) {
                    RareIceBlockEntity rareIceBlockEntity = (RareIceBlockEntity)blockEntity;
                    class_1799 itemStack = player.method_5998(hand);
                    itemStack = player.method_31549().field_7477 ? itemStack.method_7972() : itemStack;
                    return rareIceBlockEntity.addItem(world, itemStack, player, !world.method_8608());
                }
            }
            return class_1269.field_5811;
        });
        BiomeModifications.addFeature(ctx -> ctx.getBiome().method_8712() < 0.15f, (class_2893.class_2895)class_2893.class_2895.field_13176, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("rare-ice", "rare_ice")));
    }
}

