/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.handler;

import appeng.api.stacks.AEItemKey;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FillCraftingGridFromRecipePacket;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.items.CraftingTermMenu;
import com.google.common.base.Preconditions;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class Ae2RecipeHandler<T extends CraftingTermMenu>
implements StandardRecipeHandler<T> {
    private final Comparator<GridInventoryEntry> BY_COUNT = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    public List<class_1735> getInputSources(T handler) {
        IClientRepo clientRepo = handler.getClientRepo();
        if (clientRepo == null) {
            return new ArrayList<class_1735>();
        }
        ArrayList<class_1735> sources = new ArrayList<class_1735>(clientRepo.getAllEntries().stream().filter(s -> s.getWhat() != null).filter(s -> s.getStoredAmount() > 0L || !s.isCraftable()).map(s -> {
            class_1799 stack = s.getWhat().wrapForDisplayOrFilter();
            long amount = s.getStoredAmount();
            int clamped = (int)(amount > 64L ? 64L : amount);
            stack.method_7939(clamped);
            return new class_1735((class_1263)new class_1277(new class_1799[]{stack}), 0, 0, 0);
        }).toList());
        sources.addAll(handler.getSlots(SlotSemantics.PLAYER_INVENTORY));
        sources.addAll(handler.getSlots(SlotSemantics.PLAYER_HOTBAR));
        sources.addAll(handler.getSlots(SlotSemantics.CRAFTING_GRID));
        return sources;
    }

    public List<class_1735> getCraftingSlots(T handler) {
        return handler.getSlots(SlotSemantics.CRAFTING_GRID);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        if (recipe instanceof EmiCraftingRecipe) {
            EmiCraftingRecipe craftingRecipe = (EmiCraftingRecipe)recipe;
            class_2960 recipeId = craftingRecipe.getId();
            class_2371<class_1799> candidates = this.findTemplateCandidates((EmiRecipe)craftingRecipe, (CraftingTermMenu)context.getScreenHandler());
            NetworkHandler.instance().sendToServer((BasePacket)new FillCraftingGridFromRecipePacket(recipeId, candidates, false));
            class_310.method_1551().method_1507((class_437)context.getScreen());
            return true;
        }
        return false;
    }

    public class_1735 getOutputSlot(T handler) {
        List slots = handler.getSlots(SlotSemantics.CRAFTING_RESULT);
        if (slots.isEmpty()) {
            return null;
        }
        return (class_1735)slots.get(0);
    }

    private class_2371<class_1799> findTemplateCandidates(EmiRecipe recipe, T menu) {
        Map prioritizedInventory = EncodingHelper.getIngredientPriorities(menu, this.BY_COUNT);
        class_2371 list = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        class_2371<EmiIngredient> normalizedMatrix = this.ensureSize(recipe);
        for (int i = 0; i < normalizedMatrix.size(); ++i) {
            EmiIngredient ingredient = (EmiIngredient)normalizedMatrix.get(i);
            if (ingredient.isEmpty()) continue;
            class_1799 stack = prioritizedInventory.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt4569$temp = e.getKey();
                return patt4569$temp instanceof AEItemKey && EmiIngredient.areEqual((EmiIngredient)ingredient, (EmiIngredient)EmiStack.of((class_1799)(itemKey = (AEItemKey)patt4569$temp).toStack()));
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(((EmiStack)ingredient.getEmiStacks().get(0)).getItemStack());
            list.set(i, (Object)stack);
        }
        return list;
    }

    private class_2371<EmiIngredient> ensureSize(EmiRecipe recipe) {
        class_2371 list = class_2371.method_10213((int)9, (Object)EmiIngredient.of((class_1856)class_1856.field_9017));
        List ingredients = recipe.getInputs();
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            int width = shapedRecipe.method_8150();
            int height = shapedRecipe.method_8158();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    EmiIngredient ingredient = (EmiIngredient)ingredients.get(source);
                    list.set(target, (Object)ingredient);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                list.set(i, (Object)((EmiIngredient)ingredients.get(i)));
            }
        }
        return list;
    }
}

