/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.recipes;

import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.ItemModText;
import appeng.core.localization.LocalizationEnum;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import org.blocovermelho.ae2emicrafting.client.recipes.Ae2AttunementRecipe;
import org.blocovermelho.ae2emicrafting.client.recipes.generator.FacadeGenerator;

public class Ae2RecipeHolder {
    public static void registerP2PAttunements(Consumer<EmiRecipe> recipeConsumer) {
        List all = EmiApi.getIndexStacks();
        for (P2PTunnelAttunementInternal.Resultant resultant : P2PTunnelAttunementInternal.getApiTunnels()) {
            List<EmiStack> inputs = all.stream().filter(stack -> resultant.stackPredicate().test(stack.getItemStack())).toList();
            if (inputs.isEmpty()) continue;
            recipeConsumer.accept((EmiRecipe)new Ae2AttunementRecipe(EmiIngredient.of(inputs), EmiStack.of((class_1935)resultant.tunnelType()), (class_2561)ItemModText.P2P_API_ATTUNEMENT.text().method_27693("\n").method_10852(resultant.description())));
        }
        for (Map.Entry entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
            EmiIngredient ingredient = EmiIngredient.of((class_6862)((class_6862)entry.getKey()));
            if (ingredient.isEmpty()) continue;
            recipeConsumer.accept((EmiRecipe)new Ae2AttunementRecipe(ingredient, EmiStack.of((class_1935)((class_1935)entry.getValue())), (class_2561)ItemModText.P2P_TAG_ATTUNEMENT.text()));
        }
    }

    public static void registerFacades(Consumer<EmiRecipe> recipeConsumer) {
        EmiApi.getIndexStacks().stream().map(FacadeGenerator::of).filter(Optional::isPresent).map(Optional::get).forEach(recipeConsumer);
    }

    public static void registerDescriptions(EmiRegistry registry) {
        Ae2RecipeHolder.addDescription(registry, AEItems.CERTUS_QUARTZ_CRYSTAL, new LocalizationEnum[]{GuiText.CertusQuartzObtain});
        if (AEConfig.instance().isSpawnPressesInMeteoritesEnabled()) {
            Ae2RecipeHolder.addDescription(registry, AEItems.LOGIC_PROCESSOR_PRESS, new LocalizationEnum[]{GuiText.inWorldCraftingPresses});
            Ae2RecipeHolder.addDescription(registry, AEItems.CALCULATION_PROCESSOR_PRESS, new LocalizationEnum[]{GuiText.inWorldCraftingPresses});
            Ae2RecipeHolder.addDescription(registry, AEItems.ENGINEERING_PROCESSOR_PRESS, new LocalizationEnum[]{GuiText.inWorldCraftingPresses});
            Ae2RecipeHolder.addDescription(registry, AEItems.SILICON_PRESS, new LocalizationEnum[]{GuiText.inWorldCraftingPresses});
        }
        Ae2RecipeHolder.addDescription(registry, AEBlocks.CRANK, new LocalizationEnum[]{ItemModText.CRANK_DESCRIPTION});
    }

    private static void addDescription(EmiRegistry registry, ItemDefinition<?> item, LocalizationEnum ... lines) {
        EmiInfoRecipe info = new EmiInfoRecipe(List.of(EmiStack.of(item)), Arrays.stream(lines).map(LocalizationEnum::text).toList(), null);
        registry.addRecipe((EmiRecipe)info);
    }
}

