/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.registry.blockRenderers.dreamBlock.texture;

import dev.mayaqq.estrogen.registry.EstrogenBlocks;
import dev.mayaqq.estrogen.registry.blockEntities.DreamBlockEntity;
import dev.mayaqq.estrogen.utils.DynamicTextureMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6007;
import net.minecraft.class_6008;
import net.minecraft.class_6012;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class DreamBlockTexture {
    public static int maxAnimTick = 30;
    public static int currentAnimationTick = 0;
    private final DynamicTextureMap map;
    private final DreamBlockEntity blockEntity;
    private final Map<class_2350, Set<Goober>> goobers = new Object2ObjectArrayMap(6);
    private final class_5819 random;
    private static final class_6005<Object> transparency = new class_6005.class_6006().method_34975((Object)0, 5).method_34975((Object)1, 2).method_34975((Object)2, 1).method_34974();

    public DreamBlockTexture(DreamBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.map = new DynamicTextureMap(16);
        class_2338 pos = blockEntity.method_11016();
        this.random = class_5819.method_43049((long)((long)pos.method_10263() + (long)pos.method_10264() * 111L + (long)pos.method_10260() * 17L));
    }

    public static void animationTick() {
        if (++currentAnimationTick > maxAnimTick) {
            currentAnimationTick = 0;
        }
    }

    public void init() {
        this.populateNodes();
        this.map.init(class_310.method_1551().method_1531(), "dream_block");
        this.map.drawAll(this::draw);
    }

    public void animate() {
        if (!class_310.method_1517()) {
            return;
        }
        int ct = currentAnimationTick;
        for (class_2350 direction : class_2350.values()) {
            for (Goober goober : this.goobers.get(direction)) {
                if (ct != goober.startTick() && ct != goober.endTick()) continue;
                this.map.draw(direction, this::draw);
            }
        }
    }

    public void redraw() {
        this.map.drawAll(this::draw);
    }

    public void renderFace(Matrix4f pose, class_4588 consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, class_2350 direction, boolean cull) {
        class_1937 level = this.blockEntity.method_10997();
        class_2338 pos = this.blockEntity.method_11016();
        if (cull && level != null && level.method_8320(pos.method_10093(direction)).method_27852((class_2248)EstrogenBlocks.DREAM_BLOCK.get())) {
            return;
        }
        consumer.method_22918(pose, x0, y0, z0).method_39415(-1).method_22913(this.map.getU0(direction), this.map.getV0(direction)).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(pose, x1, y0, z1).method_39415(-1).method_22913(this.map.getU1(direction), this.map.getV0(direction)).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(pose, x1, y1, z2).method_39415(-1).method_22913(this.map.getU1(direction), this.map.getV1(direction)).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(pose, x0, y1, z3).method_39415(-1).method_22913(this.map.getU0(direction), this.map.getV1(direction)).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(pose.normal(new Matrix3f()), 0.0f, 1.0f, 0.0f).method_1344();
    }

    public DynamicTextureMap getTextureMap() {
        return this.map;
    }

    public class_1921 getRenderType() {
        return class_1921.method_23689((class_2960)this.map.location());
    }

    private void populateNodes() {
        for (class_2350 dir : class_2350.values()) {
            if (!this.goobers.containsKey(dir)) {
                this.goobers.put(dir, (Set<Goober>)new ObjectArraySet());
            }
            int nodeCount = this.random.method_39332(6, 12);
            for (int i = 0; i < nodeCount; ++i) {
                GooberColor color = GooberColor.values()[this.random.method_39332(0, 5)];
                GooberStyle style = GooberStyle.weighted(this.random);
                int posX = this.random.method_43051(0, 16);
                int posY = this.random.method_43051(0, 16);
                int startTick = 0;
                int endTick = 0;
                boolean reverse = false;
                if (posY > 2 && posX < 14 && posX > 2 && posY < 14) {
                    boolean hasAnim = style == GooberStyle.STAR_ANIMATED;
                    startTick = hasAnim ? this.random.method_39332(0, maxAnimTick / 2) : -1;
                    endTick = hasAnim ? startTick + maxAnimTick / 2 : -1;
                    reverse = this.random.method_43056();
                }
                Goober goober = new Goober(posX, posY, color, style, startTick, endTick, reverse, DreamBlockTexture.getTransparency(this.random));
                this.goobers.get(dir).add(goober);
            }
        }
    }

    private void draw(DynamicTextureMap.DrawContext ctx) {
        class_2338 pos = this.blockEntity.method_11016();
        class_1937 level = this.blockEntity.method_10997();
        if (level != null && level.method_8320(pos.method_10093(ctx.face())).method_27852((class_2248)EstrogenBlocks.DREAM_BLOCK.get())) {
            return;
        }
        ctx.applyToPixels(i -> -300941307);
        for (Goober goober : this.goobers.get(ctx.face())) {
            goober.draw(ctx, currentAnimationTick);
        }
        this.drawBorder(ctx);
    }

    private void drawBorder(DynamicTextureMap.DrawContext ctx) {
        BiPredicate<Integer, Integer> connect = this.connectedBorder(this.blockEntity, ctx.face());
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (!connect.test(x, y)) continue;
                ctx.setPixelColor(x, y, -1);
            }
        }
    }

    protected class_2350 getUpDirection(class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis.method_10179() ? class_2350.field_11036 : class_2350.field_11043;
    }

    protected class_2350 getRightDirection(class_2350 face) {
        class_2350.class_2351 axis = face.method_10166();
        return axis == class_2350.class_2351.field_11048 ? class_2350.field_11035 : class_2350.field_11039;
    }

    private BiPredicate<Integer, Integer> connectedBorder(DreamBlockEntity be, class_2350 face) {
        class_2338 pos = be.method_11016();
        class_1937 level = be.method_10997();
        class_2248 dreamBlock = (class_2248)EstrogenBlocks.DREAM_BLOCK.get();
        BiPredicate<Integer, Integer> output = (x, y) -> false;
        boolean positive = face.method_10171() == class_2350.class_2352.field_11056;
        class_2350 right = this.getRightDirection(face);
        class_2350 up = this.getUpDirection(face);
        if (face.method_10166() == class_2350.class_2351.field_11048) {
            up = up.method_10153();
            right = right.method_10153();
        }
        class_2350 class_23502 = up = positive ? up.method_10153() : up;
        if (level == null) {
            return output;
        }
        class_2680 stateR = level.method_8320(pos.method_10093(right));
        class_2680 stateL = level.method_8320(pos.method_10093(right.method_10153()));
        class_2680 stateUp = level.method_8320(pos.method_10093(up));
        class_2680 stateDown = level.method_8320(pos.method_10093(up.method_10153()));
        if (!stateL.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 15);
        }
        if (!stateR.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 0);
        }
        if (!stateDown.method_27852(dreamBlock)) {
            output = output.or((x, y) -> y == 15);
        }
        if (!stateUp.method_27852(dreamBlock)) {
            output = output.or((x, y) -> y == 0);
        }
        class_2680 cornerUpRight = level.method_8320(pos.method_10093(up).method_10093(right));
        class_2680 cornerUpLeft = level.method_8320(pos.method_10093(up).method_10093(right.method_10153()));
        class_2680 cornerDownRight = level.method_8320(pos.method_10093(up.method_10153()).method_10093(right));
        class_2680 corderDownLeft = level.method_8320(pos.method_10093(up.method_10153()).method_10093(right.method_10153()));
        if (!cornerUpLeft.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 15 && y == 0);
        }
        if (!cornerUpRight.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 0 && y == 0);
        }
        if (!corderDownLeft.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 15 && y == 15);
        }
        if (!cornerDownRight.method_27852(dreamBlock)) {
            output = output.or((x, y) -> x == 0 && y == 15);
        }
        return output;
    }

    public static int getTransparency(class_5819 rng) {
        return (Integer)((class_6008.class_6010)transparency.method_34992(rng).get()).method_34983();
    }

    private record Goober(int x, int y, GooberColor color, GooberStyle style, int startTick, int endTick, boolean reverse, int lessOpacity) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Goober) {
                Goober n = (Goober)obj;
                return this.effectivelyEqual(n);
            }
            return false;
        }

        public boolean effectivelyEqual(Goober goober) {
            int difX = Math.abs((int)(this.x - goober.x));
            int difY = Math.abs((int)(this.y - goober.y));
            return difX < 4 && difY < 4 || (difX < 2 || difY < 2) && this.style != GooberStyle.PIXEL;
        }

        public void draw(DynamicTextureMap.DrawContext context, int animTick) {
            int col = this.color.color;
            switch (this.lessOpacity) {
                case 1: {
                    col = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                    col = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                }
                case 2: {
                    col = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                    col = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                    col = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                }
            }
            if (this.x < 15 && this.y < 15 && this.x > 0 && this.y > 0) {
                switch (this.style) {
                    case PIXEL: {
                        context.setPixelColor(this.x, this.y, col);
                        break;
                    }
                    case STAR: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        break;
                    }
                    case STAR_ANIMATED: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        if (!this.testAnimation(animTick)) break;
                        context.setPixelColorSafe(this.x + 2, this.y, col);
                        context.setPixelColorSafe(this.x - 2, this.y, col);
                        context.setPixelColorSafe(this.x, this.y + 2, col);
                        context.setPixelColorSafe(this.x, this.y - 2, col);
                        int transCol = class_5253.class_5254.method_27763((int)col, (int)-23488103);
                        context.setPixelColorSafe(this.x + 1, this.y + 1, transCol);
                        context.setPixelColorSafe(this.x - 1, this.y - 1, transCol);
                        context.setPixelColorSafe(this.x - 1, this.y + 1, transCol);
                        context.setPixelColorSafe(this.x + 1, this.y - 1, transCol);
                        break;
                    }
                    case THINGY: {
                        context.setPixelColor(this.x + 1, this.y, col);
                        context.setPixelColor(this.x, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y, col);
                        context.setPixelColor(this.x, this.y - 1, col);
                        context.setPixelColor(this.x + 1, this.y + 1, col);
                        context.setPixelColor(this.x - 1, this.y - 1, col);
                    }
                }
            } else {
                context.setPixelColor(this.x, this.y, col);
            }
        }

        private boolean testAnimation(int tick) {
            return this.reverse != (tick >= this.startTick && tick < this.endTick);
        }
    }

    private static enum GooberColor {
        YELLOW(GooberColor.rgb(255, 255, 0)),
        CYAN(GooberColor.rgb(0, 241, 254)),
        PURPLE(GooberColor.rgb(66, 66, 158)),
        MAGENTA(GooberColor.rgb(255, 71, 231)),
        GREEN1(GooberColor.rgb(40, 125, 77)),
        GREEN2(GooberColor.rgb(0, 158, 13));

        final int color;

        private GooberColor(int color) {
            this.color = color;
        }

        public int red() {
            return class_5253.class_5254.method_27765((int)this.color);
        }

        public int green() {
            return class_5253.class_5254.method_27766((int)this.color);
        }

        public int blue() {
            return class_5253.class_5254.method_27767((int)this.color);
        }

        public static int rgb(int r, int g, int b) {
            return class_5253.class_5254.method_27764((int)255, (int)b, (int)g, (int)r);
        }
    }

    private static enum GooberStyle implements class_6008
    {
        PIXEL(2),
        STAR(3),
        THINGY(1),
        STAR_ANIMATED(3);

        final class_6007 weight;
        private static final class_6012<GooberStyle> weightedRandomList;

        private GooberStyle(int weight) {
            this.weight = class_6007.method_34977((int)weight);
        }

        public class_6007 method_34979() {
            return this.weight;
        }

        public static GooberStyle weighted(class_5819 rng) {
            return (GooberStyle)((Object)weightedRandomList.method_34992(rng).get());
        }

        static {
            weightedRandomList = class_6012.method_34989((class_6008[])GooberStyle.values());
        }
    }
}

