/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.fabric.integrations.rei;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.compat.rei.BlueprintTransferHandler;
import com.simibubi.create.compat.rei.CreateREI;
import com.simibubi.create.compat.rei.DoubleItemIcon;
import com.simibubi.create.compat.rei.EmptyBackground;
import com.simibubi.create.compat.rei.GhostIngredientHandler;
import com.simibubi.create.compat.rei.ItemIcon;
import com.simibubi.create.compat.rei.SlotMover;
import com.simibubi.create.compat.rei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import dev.architectury.fluid.FluidStack;
import dev.mayaqq.estrogen.Estrogen;
import dev.mayaqq.estrogen.fabric.integrations.rei.categories.CentrifugingCategory;
import dev.mayaqq.estrogen.fabric.integrations.rei.categories.EntityInteractionCategory;
import dev.mayaqq.estrogen.fabric.integrations.rei.displays.EstrogenDisplays;
import dev.mayaqq.estrogen.registry.EstrogenBlocks;
import dev.mayaqq.estrogen.registry.EstrogenProcessingRecipes;
import dev.mayaqq.estrogen.registry.recipes.CentrifugingRecipe;
import dev.mayaqq.estrogen.registry.recipes.EntityInteractionRecipe;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;

public class ReiCompat
extends CreateREI {
    private static final class_2960 ID = Estrogen.id("rei_plugin");
    final List<CreateRecipeCategory<?>> ALL = new ArrayList();

    public static void consumeAllRecipes(@NotNull Consumer<class_1860<?>> consumer) {
        class_310.method_1551().field_1687.method_8433().method_8126().forEach(consumer);
    }

    public static <T extends class_1860<?>> void consumeTypedRecipes(@NotNull Consumer<T> consumer, @NotNull class_3956<?> type) {
        Map map = (Map)((RecipeManagerAccessor)class_310.method_1551().method_1562().method_2877()).port_lib$getRecipes().get(type);
        if (map != null) {
            map.values().forEach(recipe -> consumer.accept(recipe));
        }
    }

    public static List<class_1860<?>> getTypedRecipes(@NotNull class_3956<?> type) {
        ArrayList recipes = new ArrayList();
        ReiCompat.consumeTypedRecipes(recipes::add, type);
        return recipes;
    }

    public static List<class_1860<?>> getTypedRecipesExcluding(@NotNull class_3956<?> type, @NotNull Predicate<class_1860<?>> exclusionPred) {
        List<class_1860<?>> recipes = ReiCompat.getTypedRecipes(type);
        recipes.removeIf(exclusionPred);
        return recipes;
    }

    public static boolean doInputsMatch(class_1860<?> recipe1, @NotNull class_1860<?> recipe2) {
        if (recipe1.method_8117().isEmpty() || recipe2.method_8117().isEmpty()) {
            return false;
        }
        class_1799[] matchingStacks = ((class_1856)recipe1.method_8117().get(0)).method_8105();
        if (matchingStacks.length == 0) {
            return false;
        }
        return ((class_1856)recipe2.method_8117().get(0)).method_8093(matchingStacks[0]);
    }

    private void loadCategories() {
        this.ALL.clear();
        CreateRecipeCategory<CentrifugingRecipe> centrifuging = this.builder(CentrifugingRecipe.class).addTypedRecipes(EstrogenProcessingRecipes.CENTRIFUGING).catalyst(() -> EstrogenBlocks.CENTRIFUGE.get()).itemIcon((class_1935)EstrogenBlocks.CENTRIFUGE.get()).emptyBackground(177, 80).displayFactory(EstrogenDisplays::centrifuging).build("centrifuging", (CreateRecipeCategory.Factory<CentrifugingRecipe>)((CreateRecipeCategory.Factory)CentrifugingCategory::new));
        CreateRecipeCategory<EntityInteractionRecipe> entity_interaction = this.builder(EntityInteractionRecipe.class).addTypedRecipes(EntityInteractionRecipe.getRecipeTypeInfo()).doubleItemIcon((class_1935)class_1802.field_8470, (class_1935)AllItems.BRASS_HAND).emptyBackground(177, 80).displayFactory(EstrogenDisplays::entityInteraction).build("entity_interaction", (CreateRecipeCategory.Factory<EntityInteractionRecipe>)((CreateRecipeCategory.Factory)EntityInteractionCategory::new));
    }

    private <T extends class_1860<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public String getPluginProviderName() {
        return ID.toString();
    }

    public void registerCategories(@NotNull CategoryRegistry registry) {
        this.loadCategories();
        this.ALL.forEach(category -> {
            registry.add((DisplayCategory)category);
            category.registerCatalysts(registry);
        });
    }

    public void registerDisplays(@NotNull DisplayRegistry registry) {
        this.ALL.forEach(c -> c.registerRecipes(registry));
        List recipes = ToolboxColoringRecipeMaker.createRecipes().toList();
        for (class_3955 recipe : recipes) {
            Collection displays = registry.tryFillDisplay((Object)recipe);
            for (Display display : displays) {
                if (!Objects.equals(display.getCategoryIdentifier(), CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting"))) continue;
                registry.add(display, (Object)recipe);
            }
        }
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(AbstractSimiContainerScreen.class, (ExclusionZonesProvider)new SlotMover());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new GhostIngredientHandler());
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)new BlueprintTransferHandler());
    }

    public void registerEntries(EntryRegistry registry) {
        registry.removeEntryIf(entryStack -> {
            if (entryStack.getType() == VanillaEntryTypes.ITEM) {
                class_1799 itemStack = (class_1799)entryStack.castValue();
                class_1792 patt7543$temp = itemStack.method_7909();
                if (patt7543$temp instanceof TagDependentIngredientItem) {
                    TagDependentIngredientItem tagItem = (TagDependentIngredientItem)patt7543$temp;
                    return tagItem.shouldHide();
                }
            } else if (entryStack.getType() == VanillaEntryTypes.FLUID) {
                FluidStack fluidStack = (FluidStack)entryStack.castValue();
                return fluidStack.getFluid() instanceof VirtualFluid;
            }
            return false;
        });
    }

    private class CategoryBuilder<T extends class_1860<?>> {
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends class_1799>> catalysts = new ArrayList<Supplier<? extends class_1799>>();
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private Renderer background;
        private Renderer icon;
        private int width;
        private int height;
        private Function<T, ? extends CreateDisplay<T>> displayFactory;

        public CategoryBuilder(Class<? extends T> recipeClass) {
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred) {
            return this.addRecipeListConsumer(recipes -> ReiCompat.consumeAllRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<class_1860<?>> pred, Function<class_1860<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> ReiCompat.consumeAllRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add((class_1860)converter.apply((class_1860<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<class_3956<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipes::add, (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<class_3956<? extends T>> recipeType, Function<class_1860<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipe -> recipes.add((class_1860)converter.apply((class_1860<?>)recipe)), (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<class_3956<? extends T>> recipeType, Predicate<class_1860<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateREI.consumeTypedRecipes(recipe -> {
                if (pred.test((class_1860<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (class_3956)((class_3956)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<class_3956<? extends T>> recipeType, Supplier<class_3956<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<class_1860<?>> excludedRecipes = ReiCompat.getTypedRecipes((class_3956)excluded.get());
                CreateREI.consumeTypedRecipes(recipe -> {
                    for (class_1860 excludedRecipe : excludedRecipes) {
                        if (!ReiCompat.doInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (class_3956)((class_3956)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<class_3956<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<class_1860<?>> excludedRecipes = ReiCompat.getTypedRecipes((class_3956)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (class_1860 excludedRecipe : excludedRecipes) {
                        if (!ReiCompat.doInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<class_1799> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<class_1935> supplier) {
            return this.catalystStack(() -> new class_1799((class_1935)((class_1935)supplier.get()).method_8389()));
        }

        public CategoryBuilder<T> icon(Renderer icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(class_1935 item) {
            this.icon((Renderer)new ItemIcon(() -> new class_1799(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(class_1935 item1, class_1935 item2) {
            this.icon((Renderer)new DoubleItemIcon(() -> new class_1799(item1), () -> new class_1799(item2)));
            return this;
        }

        public CategoryBuilder<T> background(Renderer background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((Renderer)new EmptyBackground(width, height));
            this.dimensions(width, height);
            return this;
        }

        public CategoryBuilder<T> width(int width) {
            this.width = width;
            return this;
        }

        public CategoryBuilder<T> height(int height) {
            this.height = height;
            return this;
        }

        public CategoryBuilder<T> dimensions(int width, int height) {
            this.width(width);
            this.height(height);
            return this;
        }

        public CategoryBuilder<T> displayFactory(Function<T, ? extends CreateDisplay<T>> factory) {
            this.displayFactory = factory;
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                if (this.predicate.test(AllConfigs.server().recipes)) {
                    for (Consumer consumer : this.recipeListConsumers) {
                        consumer.accept(recipes);
                    }
                }
                return recipes;
            } : () -> Collections.emptyList();
            if (this.width <= 0 || this.height <= 0) {
                Create.LOGGER.warn("Create REI category [{}] has weird dimensions: {}x{}", new Object[]{name, this.width, this.height});
            }
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(CategoryIdentifier.of((class_2960)Estrogen.id(name)), (class_2561)Lang.translateDirect((String)("recipe." + name), (Object[])new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts, this.width, this.height, this.displayFactory == null ? recipe -> new CreateDisplay(recipe, CategoryIdentifier.of((class_2960)Estrogen.id(name))) : this.displayFactory);
            CreateRecipeCategory category = factory.create(info);
            ReiCompat.this.ALL.add(category);
            return category;
        }
    }
}

