/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.utils;

import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class DynamicTextureMap {
    private class_1043 mapTex;
    private class_2960 mapTexId;
    private final int resolution;
    private boolean released = true;

    public DynamicTextureMap(int resolution) {
        this.resolution = resolution;
    }

    public void init(class_1060 manager, String id) {
        this.released = false;
        this.mapTex = new class_1043(this.resolution * 3, this.resolution * 2, false);
        this.mapTexId = manager.method_4617(id, this.mapTex);
    }

    public void drawAll(Consumer<DrawContext> drawCallback) {
        if (this.released) {
            return;
        }
        try (DrawContext ctx = new DrawContext(this);){
            for (class_2350 dir : class_2350.values()) {
                ctx.mapFace(dir);
                drawCallback.accept(ctx);
            }
        }
    }

    public void draw(class_2350 dir, Consumer<DrawContext> drawCallback) {
        if (this.released) {
            return;
        }
        try (DrawContext ctx = new DrawContext(this);){
            ctx.mapFace(dir);
            drawCallback.accept(ctx);
        }
    }

    public class_2960 location() {
        return this.mapTexId;
    }

    public float getU(float u, class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> u / 3.0f;
            case class_2350.field_11043, class_2350.field_11035 -> u / 3.0f + 0.33333334f;
            case class_2350.field_11039, class_2350.field_11034 -> u / 3.0f + 0.6666667f;
        };
    }

    public float getU0(class_2350 dir) {
        return this.getU(0.0f, dir);
    }

    public float getU1(class_2350 dir) {
        return this.getU(1.0f, dir);
    }

    public float getV(float v, class_2350 dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036, class_2350.field_11043, class_2350.field_11034 -> v / 2.0f;
            case class_2350.field_11033, class_2350.field_11035, class_2350.field_11039 -> v / 2.0f + 0.5f;
        };
    }

    public float getV0(class_2350 dir) {
        return this.getV(0.0f, dir);
    }

    public float getV1(class_2350 dir) {
        return this.getV(1.0f, dir);
    }

    public void release() {
        this.released = true;
    }

    public static class DrawContext
    implements AutoCloseable {
        private final DynamicTextureMap map;
        private final class_1011 pixels;
        private class_2350 face;
        private int offsetX;
        private int offsetY;
        private boolean shouldUpload = true;

        public DrawContext(DynamicTextureMap map) {
            this.map = map;
            this.offsetX = 0;
            this.offsetY = 0;
            this.face = class_2350.field_11036;
            this.pixels = map.mapTex.method_4525();
        }

        public void setPixelColor(int x, int y, int colorABGR) {
            this.pixels.method_4305(x + this.offsetX, y + this.offsetY, colorABGR);
        }

        public void setPixelColorSafe(int x, int y, int abgr) {
            if (x >= this.map.resolution || x < 0 || y >= this.map.resolution || y < 0) {
                return;
            }
            this.setPixelColor(x, y, abgr);
        }

        public int getPixelColor(int x, int y) {
            return this.pixels.method_4315(x, y);
        }

        public void blendPixel(int x, int y, int colorAGBR) {
            this.pixels.method_35624(x + this.offsetX, y + this.offsetY, colorAGBR);
        }

        public void applyToPixels(IntUnaryOperator operator) {
            for (int y = this.offsetY; y < this.map.resolution + this.offsetY; ++y) {
                for (int x = this.offsetX; x < this.map.resolution + this.offsetX; ++x) {
                    this.pixels.method_4305(x, y, operator.applyAsInt(this.pixels.method_4315(x, y)));
                }
            }
        }

        private void mapFace(class_2350 dir) {
            this.face = dir;
            this.offsetX = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11033, class_2350.field_11036 -> 0;
                case class_2350.field_11043, class_2350.field_11035 -> this.map.resolution;
                case class_2350.field_11039, class_2350.field_11034 -> this.map.resolution * 2;
            };
            this.offsetY = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11036, class_2350.field_11043, class_2350.field_11034 -> 0;
                case class_2350.field_11033, class_2350.field_11035, class_2350.field_11039 -> this.map.resolution;
            };
        }

        public DynamicTextureMap getMap() {
            return this.map;
        }

        public class_1043 getMapTex() {
            return this.map.mapTex;
        }

        public class_2350 face() {
            return this.face;
        }

        public void cancel() {
            this.shouldUpload = false;
        }

        @Override
        public void close() {
            if (this.shouldUpload) {
                this.map.mapTex.method_4524();
            }
        }
    }
}

