/*
 * Decompiled with CFR 0.152.
 */
package elocindev.create_questing.fabric.mixin;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.Chapter;
import elocindev.create_questing.fabric.CreateQuesting;
import elocindev.create_questing.fabric.config.ConfigEntries;
import elocindev.create_questing.fabric.theme.CreateTheme;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={QuestScreen.class})
public class QuestScreenMixin {
    @Shadow
    Chapter selectedChapter;
    @Shadow
    double scrollWidth;
    @Shadow
    double scrollHeight;
    @Shadow
    int prevMouseX;
    @Shadow
    int prevMouseY;
    @Shadow
    MouseButton grabbed;

    @Inject(method={"drawBackground"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    public void create_questing_drawBlueprint(class_332 graphics, Theme theme, int x, int y, int w, int h, CallbackInfo info) {
        QuestScreen inst = (QuestScreen)this;
        ConfigEntries cfg = CreateQuesting.Config;
        boolean valid = false;
        if (this.selectedChapter == null) {
            return;
        }
        if (cfg.enable_theme_only_in_create_chapters) {
            for (String keyword : cfg.create_chapter_names) {
                if (!this.selectedChapter.getTitle().toString().toLowerCase().contains(keyword.toLowerCase())) continue;
                valid = true;
            }
            if (!valid) {
                return;
            }
        }
        int scale = (int)(cfg.blueprint_background_scale * 256.0f);
        theme = new CreateTheme();
        int offsetX = (int)Math.ceil((double)w / (double)scale);
        int offsetY = (int)Math.ceil((double)h / (double)scale);
        for (int i = 0; i < offsetX; ++i) {
            for (int j = 0; j < offsetY; ++j) {
                CreateTheme.BACKGROUND_SQUARES.draw(graphics, x + i * scale, y + j * scale, scale, scale);
            }
        }
        if (this.grabbed != null) {
            int mx = inst.getMouseX();
            int my = inst.getMouseY();
            if (this.grabbed.isLeft()) {
                if (this.scrollWidth > (double)inst.questPanel.width) {
                    inst.questPanel.setScrollX(Math.max(Math.min(inst.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)inst.questPanel.width), 0.0));
                } else {
                    inst.questPanel.setScrollX((this.scrollWidth - (double)inst.questPanel.width) / 2.0);
                }
                if (this.scrollHeight > (double)inst.questPanel.height) {
                    inst.questPanel.setScrollY(Math.max(Math.min(inst.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)inst.questPanel.height), 0.0));
                } else {
                    inst.questPanel.setScrollY((this.scrollHeight - (double)inst.questPanel.height) / 2.0);
                }
                this.prevMouseX = mx;
                this.prevMouseY = my;
            } else if (this.grabbed.isMiddle()) {
                int boxX = Math.min(this.prevMouseX, mx);
                int boxY = Math.min(this.prevMouseY, my);
                int boxW = Math.abs(mx - this.prevMouseX);
                int boxH = Math.abs(my - this.prevMouseY);
                GuiHelper.drawHollowRect((class_332)graphics, (int)boxX, (int)boxY, (int)boxW, (int)boxH, (Color4I)Color4I.DARK_GRAY, (boolean)false);
                Color4I.DARK_GRAY.withAlpha(40).draw(graphics, boxX, boxY, boxW, boxH);
            }
        }
        info.cancel();
    }
}

