/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.blockswap.swapper;

import com.mojang.serialization.Codec;
import corgitaco.blockswap.config.BlockSwapConfig;
import corgitaco.blockswap.mixin.access.StateHolderAccess;
import corgitaco.blockswap.util.CodecUtil;
import corgitaco.blockswap.util.CommentedCodec;
import corgitaco.blockswap.util.TickHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;

public class Swapper {
    public static final Codec<class_2680> COMMENTED_STATE_CODEC = Swapper.codec(CodecUtil.BLOCK_CODEC, class_2248::method_9564);
    public static final Codec<class_3610> COMMENTED_FLUID_CODEC = Swapper.codec(CodecUtil.FLUID_CODEC, class_3611::method_15785);
    public static Reference2ReferenceOpenHashMap<class_2248, Int2ObjectOpenHashMap<class_2769<?>>> cache = new Reference2ReferenceOpenHashMap();

    protected static <O, S extends class_2688<O, S>> Codec<S> codec(Codec<O> object, Function<O, S> defaultVal) {
        return object.dispatch("Name", stateHolder -> ((StateHolderAccess)stateHolder).blockSwap_GetOwner(), o -> {
            class_2688 stateProperty = (class_2688)defaultVal.apply(o);
            return stateProperty.method_11656().isEmpty() ? Codec.unit((Object)stateProperty) : CommentedCodec.optionalOf(((StateHolderAccess)stateProperty).blockSwap_getPropertiesCodec().codec(), "Properties", "Properties define the state of this block/fluid.", stateProperty).codec();
        });
    }

    public static class_2680 remapState(class_2680 incomingState) {
        class_2680 newState;
        BlockSwapConfig config = BlockSwapConfig.getConfig(false);
        if (config.blockStateBlockStateMap().containsKey(incomingState)) {
            return config.blockStateBlockStateMap().get(incomingState);
        }
        class_2680 finalNewState = newState = config.blockBlockMap().get(incomingState.method_26204()).method_9564();
        Int2ObjectOpenHashMap newStateProperties = (Int2ObjectOpenHashMap)cache.computeIfAbsent((Object)newState.method_26204(), block1 -> (Int2ObjectOpenHashMap)class_156.method_654((Object)new Int2ObjectOpenHashMap(), set -> {
            for (class_2769 property : finalNewState.method_28501()) {
                set.put(property.method_11799(), (Object)property);
            }
        }));
        for (class_2769 property : incomingState.method_28501()) {
            class_2769 newProperty = (class_2769)newStateProperties.get(property.method_11799());
            if (newProperty == null) continue;
            newState = (class_2680)newState.method_11657(newProperty, incomingState.method_11654(newProperty));
        }
        return newState;
    }

    public static void runRetroGenerator(class_1937 world, class_2826[] sections, class_2818 chunk) {
        BlockSwapConfig config = BlockSwapConfig.getConfig(false);
        if (config.retroGen() && !((TickHelper)chunk).markTickDirty()) {
            for (int i = 0; i < sections.length; ++i) {
                class_2826 section = sections[i];
                if (section == null) continue;
                int bottomY = class_4076.method_18688((int)chunk.method_31604(i));
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            class_2338 blockPos = new class_2338(class_4076.method_18688((int)chunk.method_12004().field_9181) + x, bottomY + y, class_4076.method_18688((int)chunk.method_12004().field_9180) + z);
                            class_2680 state = world.method_8320(blockPos);
                            if (config.blockBlockMap().containsKey(state.method_26204())) {
                                world.method_8652(blockPos, Swapper.remapState(state), 2);
                            }
                            if (!config.blockStateBlockStateMap().containsKey(state)) continue;
                            world.method_8652(blockPos, config.blockStateBlockStateMap().get(state), 2);
                        }
                    }
                }
            }
            ((TickHelper)chunk).setTickDirty();
        }
    }
}

