/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class EditConfigListScreen<E, CV extends ConfigValue<E>>
extends BaseScreen {
    private final ListConfig<E, CV> list;
    private final ConfigCallback callback;
    private final class_2561 title;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final PanelScrollBar scroll;

    public EditConfigListScreen(ListConfig<E, CV> l, ConfigCallback cb) {
        this.list = l;
        this.callback = cb;
        this.title = class_2561.method_43470((String)this.list.getName()).method_27692(class_124.field_1067);
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (int i = 0; i < ((List)EditConfigListScreen.this.list.getValue()).size(); ++i) {
                    this.add(new ButtonConfigValue((Panel)this, EditConfigListScreen.this.list, i));
                }
                if (EditConfigListScreen.this.list.getCanEdit()) {
                    this.add(new ButtonAddValue(this));
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                this.align(WidgetLayout.VERTICAL);
            }
        };
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.accept"), Icons.ACCEPT, (widget, button) -> this.doAccept());
        this.buttonCancel = new SimpleButton(this, (class_2561)class_2561.method_43471((String)"gui.cancel"), Icons.CANCEL, (widget, button) -> this.doCancel());
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
    }

    private void doAccept() {
        this.callback.save(true);
    }

    private void doCancel() {
        this.callback.save(false);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.buttonCancel.onClicked(MouseButton.LEFT);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        EditConfigScreen.COLOR_BACKGROUND.draw(graphics, 0, 0, w, 20);
        theme.drawString(graphics, this.getTitle(), 6, 6, 2);
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return EditConfigScreen.THEME;
    }

    public static class ButtonConfigValue<E, CV extends ConfigValue<E>>
    extends Button {
        public final ListConfig<E, CV> list;
        public final int index;

        public ButtonConfigValue(Panel panel, ListConfig<E, CV> list, int index) {
            super(panel);
            this.list = list;
            this.index = index;
            this.setHeight(12);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            MutableColor4I textCol = ((ConfigValue)this.list.getType()).getColor(((List)this.list.getValue()).get(this.index)).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
                if (this.getMouseX() >= x + w - 19) {
                    Color4I.WHITE.withAlpha(33).draw(graphics, x + w - 19, y, 19, h);
                }
            }
            theme.drawString(graphics, this.getGui().getTheme().trimStringToWidth((class_5348)((ConfigValue)this.list.getType()).getStringForGUI(((List)this.list.getValue()).get(this.index)), this.width), x + 4, y + 2, textCol, 0);
            if (mouseOver) {
                theme.drawString(graphics, "[-]", x + w - 16, y + 2, Color4I.WHITE, 0);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                if (this.list.getCanEdit()) {
                    ((List)this.list.getValue()).remove(this.index);
                    this.parent.refreshWidgets();
                }
            } else {
                ((ConfigValue)this.list.getType()).setValue(((List)this.list.getValue()).get(this.index));
                ((ConfigValue)this.list.getType()).onClicked(button, accepted -> {
                    if (accepted) {
                        ((List)this.list.getValue()).set(this.index, ((ConfigValue)this.list.getType()).getValue());
                    }
                    this.openGui();
                });
            }
        }

        @Override
        public void addMouseOverText(TooltipList l) {
            if (this.getMouseX() >= this.getX() + this.width - 19) {
                l.translate("selectServer.delete", new Object[0]);
            } else {
                ((ConfigValue)this.list.getType()).setValue(((List)this.list.getValue()).get(this.index));
                ((ConfigValue)this.list.getType()).addInfo(l);
            }
        }
    }

    public class ButtonAddValue
    extends Button {
        public ButtonAddValue(Panel panel) {
            super(panel);
            this.setHeight(12);
            this.setTitle((class_2561)class_2561.method_43470((String)"+ ").method_10852((class_2561)class_2561.method_43471((String)"gui.add")));
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(graphics, x, y, w, h);
            }
            theme.drawString(graphics, this.getTitle(), x + 4, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            Object listType = EditConfigListScreen.this.list.getType();
            ((ConfigValue)listType).setValue(((ConfigValue)listType).getDefaultValue() == null ? null : (Object)((ConfigValue)listType).copy(((ConfigValue)listType).getDefaultValue()));
            ((ConfigValue)listType).onClicked(button, accepted -> {
                if (accepted) {
                    ((List)EditConfigListScreen.this.list.getValue()).add(listType.getValue());
                }
                this.openGui();
            });
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }
    }
}

