/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.villagersplus.tradeoffers;

import com.finallion.villagersplus.VillagersPlus;
import com.finallion.villagersplus.tradeoffers.TradeOfferRegistryLoader;
import com.finallion.villagersplus.tradeoffers.trades.JsonBuyItemTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonProcessItemTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonSellEnchantedBookTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonSellEnchantedToolTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonSellItemTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonSellPotionTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonSellStructureMapTradeOffer;
import com.finallion.villagersplus.tradeoffers.trades.JsonTradeOffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class TradeOfferManager {
    public static final Map<String, Integer> professionMapping = new HashMap<String, Integer>();
    public static final Map<class_2960, JsonTradeOffer> tradeOfferRegistry = new HashMap<class_2960, JsonTradeOffer>();

    public static void registerTradeOffers() {
        VillagersPlus.LOGGER.info("Registered JSON trade offer adapter.");
        tradeOfferRegistry.put(new class_2960("villagersplus", "sell_item"), new JsonSellItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "buy_item"), new JsonBuyItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "process_item"), new JsonProcessItemTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "sell_potion"), new JsonSellPotionTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "sell_enchanted_tool"), new JsonSellEnchantedToolTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "sell_enchanted_book"), new JsonSellEnchantedBookTradeOffer());
        tradeOfferRegistry.put(new class_2960("villagersplus", "sell_map"), new JsonSellStructureMapTradeOffer());
    }

    public static void deserializeJson(JsonObject jsonRoot) {
        class_2960 professionId = class_2960.method_12829((String)jsonRoot.get("profession").getAsString());
        class_7923.field_41195.method_17966(professionId).ifPresent(villagerProfession -> TradeOfferManager.deserializeTrades(jsonRoot, (integer, factory) -> TradeOfferRegistryLoader.registerVillagerTrade(villagerProfession, integer, factory)));
    }

    private static void deserializeTrades(@NotNull JsonObject jsonRoot, BiConsumer<Integer, class_3853.class_1652> tradeConsumer) {
        for (Map.Entry entry : jsonRoot.get("trades").getAsJsonObject().entrySet()) {
            int level = professionMapping.get(entry.getKey());
            JsonArray tradesArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject trade = tradeElement.getAsJsonObject();
                JsonTradeOffer adapter = tradeOfferRegistry.get(class_2960.method_12829((String)trade.get("type").getAsString()));
                if (adapter == null) {
                    VillagersPlus.LOGGER.error("Trade type: " + trade.get("type").getAsString() + " is broken.");
                    VillagersPlus.LOGGER.error("Error in deserializing trades.Trade element: " + tradeElement + " and Trade: " + trade + " in " + tradesArray + " is broken. \nSending faulty JSON: " + jsonRoot);
                    continue;
                }
                tradeConsumer.accept(level, adapter.deserialize(trade));
            }
        }
    }

    static {
        professionMapping.put("novice", 1);
        professionMapping.put("apprentice", 2);
        professionMapping.put("journeyman", 3);
        professionMapping.put("expert", 4);
        professionMapping.put("master", 5);
    }
}

