/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Logger;

public class JsonUtil {
    public static boolean checkAndLogEmpty(JsonElement e, class_2960 id, String type, Logger logger) {
        String s = e.toString();
        if (s.isEmpty() || "{}".equals(s)) {
            logger.error("Ignoring {} item with id {} as it is empty.  Please switch to a condition-false json instead of an empty one.", (Object)type, (Object)id);
            return false;
        }
        return true;
    }

    public static boolean checkConditions(JsonElement e, class_2960 id, String type, Logger logger) {
        if (!e.isJsonObject() || JsonUtil.processConditions(e.getAsJsonObject(), "conditions")) {
            return true;
        }
        logger.trace("Skipping loading {} item with id {} as it's conditions were not met", (Object)type, (Object)id);
        return false;
    }

    public static boolean processConditions(JsonArray conditions) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            if (JsonUtil.getConditionPredicate(json).test(json)) continue;
            return false;
        }
        return true;
    }

    public static boolean processConditions(JsonObject json, String memberName) {
        return !json.has(memberName) || JsonUtil.processConditions(class_3518.method_15261((JsonObject)json, (String)memberName));
    }

    public static Predicate<JsonObject> getConditionPredicate(JsonObject json) {
        return ResourceConditions.get((class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"condition")));
    }

    public static <T> T getRegistryObject(JsonObject parent, String name, class_2378<T> registry) {
        String key = class_3518.method_15265((JsonObject)parent, (String)name);
        Object regObj = registry.method_10223(new class_2960(key));
        if (regObj == null) {
            throw new JsonSyntaxException("Failed to parse " + registry.method_10206(regObj) + " object with key " + key);
        }
        return (T)regObj;
    }

    @Deprecated
    public static <T> Object makeSerializer(class_2378<T> reg) {
        return new SDS<T>(reg);
    }

    @Deprecated
    public static <T> Object makeSerializer(com.google.gson.JsonDeserializer<T> jds, com.google.gson.JsonSerializer<T> js) {
        return new SDS2<T>(jds, js);
    }

    @Deprecated
    private static class SDS<T>
    implements com.google.gson.JsonDeserializer<T>,
    com.google.gson.JsonSerializer<T> {
        private final class_2378<T> reg;

        SDS(class_2378<T> reg) {
            this.reg = reg;
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(this.reg.method_10221(src).toString());
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Object regObj = this.reg.method_10223(new class_2960(json.getAsString()));
            if (regObj == null) {
                throw new JsonSyntaxException("Failed to parse " + this.reg.method_10206(regObj) + " object with key " + json.getAsString());
            }
            return (T)regObj;
        }
    }

    @Deprecated
    private record SDS2<T>(com.google.gson.JsonDeserializer<T> jds, com.google.gson.JsonSerializer<T> js) implements com.google.gson.JsonDeserializer<T>,
    com.google.gson.JsonSerializer<T>
    {
        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return this.js.serialize(src, typeOfSrc, context);
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (T)this.jds.deserialize(json, typeOfT, context);
        }
    }

    @Deprecated
    public static interface NetDeserializer<V> {
        public V read(class_2540 var1);
    }

    @Deprecated
    public static interface NetSerializer<V> {
        public void write(V var1, class_2540 var2);
    }

    @Deprecated
    public static interface JsonDeserializer<V> {
        public V read(JsonObject var1);
    }

    @Deprecated
    public static interface JsonSerializer<V> {
        public JsonObject write(V var1);
    }
}

