/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.mojang.datafixers.util.Either;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.events.ServerEvents;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class ReloadListenerPacket<T extends ReloadListenerPacket<T>> {
    final String path;

    public ReloadListenerPacket(String path) {
        this.path = path;
    }

    public static class End
    extends ReloadListenerPacket<End> {
        public static class_2960 ID = new class_2960("fakerlib", "reload_listener_end");

        public End(String path) {
            super(path);
        }

        public void write(End msg, class_2540 buf) {
            buf.method_10788(msg.path, 50);
        }

        public End read(class_2540 buf) {
            return new End(buf.method_10800(50));
        }

        public void handle(End msg) {
            DynamicRegistry.SyncManagement.endSync(msg.path);
        }

        @Environment(value=EnvType.CLIENT)
        public static <V> void setup() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, handler, buf, responseSender) -> {
                String path = buf.method_10800(50);
                DynamicRegistry.SyncManagement.endSync(path);
            });
        }

        public static void sendToAll(String path) {
            if (ServerEvents.getCurrentServer() != null) {
                List list = ServerEvents.getCurrentServer().method_3760().method_14571();
                for (class_3222 p : list) {
                    End.sendTo(p, path);
                }
            }
        }

        public static void sendTo(class_3222 player, String path) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10788(path, 50);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
            DynamicRegistry.SyncManagement.endSync(path);
        }
    }

    public static class Content<V extends CodecProvider<? super V>>
    extends ReloadListenerPacket<Content<V>> {
        public static class_2960 ID = new class_2960("fakerlib", "reload_listener_content");
        final class_2960 key;
        final Either<V, class_2540> data;

        public Content(String path, class_2960 key, V item) {
            super(path);
            this.key = key;
            this.data = Either.left(item);
        }

        private Content(String path, class_2960 key, class_2540 buf) {
            super(path);
            this.key = key;
            this.data = Either.right((Object)buf);
        }

        private V readItem() {
            class_2540 buf = (class_2540)this.data.right().get();
            try {
                CodecProvider codecProvider = (CodecProvider)DynamicRegistry.SyncManagement.readItem(this.path, buf);
                return (V)codecProvider;
            }
            catch (Exception ex) {
                Placebo.LOGGER.error("Failure when deserializing a dynamic registry object via network: Registry: {}, Object ID: {}", (Object)this.path, (Object)this.key);
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
            finally {
                buf.release();
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static <V> void setup() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, handler, buf, responseSender) -> {
                String path = buf.method_10800(50);
                class_2960 key = buf.method_10810();
                Content content = new Content(path, key, new class_2540(buf.copy()));
                DynamicRegistry.SyncManagement.acceptItem(path, key, content.readItem());
            });
        }

        public static class Provider<V extends CodecProvider<? super V>> {
            public static <R extends CodecProvider<? super R>> void sendTo(class_3222 player, String path, class_2960 k, R v) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10788(path, 50);
                buf.method_10812(k);
                DynamicRegistry.SyncManagement.writeItem(path, v, buf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
            }

            public static <R extends CodecProvider<? super R>> void sendToAll(String path, class_2960 k, R v) {
                if (ServerEvents.getCurrentServer() != null) {
                    List list = ServerEvents.getCurrentServer().method_3760().method_14571();
                    for (class_3222 p : list) {
                        Provider.sendTo(p, path, k, v);
                    }
                }
            }
        }
    }

    public static class Start
    extends ReloadListenerPacket<Start> {
        public static class_2960 ID = new class_2960("fakerlib", "reload_listener_start");

        public Start(String path) {
            super(path);
        }

        public static void sendToAll(String path) {
            if (ServerEvents.getCurrentServer() != null) {
                List list = ServerEvents.getCurrentServer().method_3760().method_14571();
                for (class_3222 p : list) {
                    Start.sendTo(p, path);
                }
            }
        }

        public static void init(class_3222 player, String path) {
            Start.sendTo(player, path);
        }

        @Environment(value=EnvType.CLIENT)
        public static void setup() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, handler, buf, responseSender) -> {
                String msg = buf.method_10800(50);
                DynamicRegistry.SyncManagement.initSync(msg);
            });
        }

        public static void sendTo(class_3222 player, String path) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10788(path, 50);
            ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
        }
    }
}

