/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_2350;
import net.minecraft.class_238;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.transformation.BooleanRotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class BoxUtils {
    public static boolean equals(double a, double b, double deviation) {
        return a == b ? true : Math.abs(a - b) < deviation;
    }

    public static boolean greaterEquals(double a, double b, double deviation) {
        return a >= (b > 0.0 ? b - deviation : b + deviation);
    }

    public static boolean insideRect(double one, double two, double minOne, double minTwo, double maxOne, double maxTwo) {
        return one > minOne && one < maxOne && two > minTwo && two < maxTwo;
    }

    private static double lengthIgnoreAxis(Vec3d vec, Axis axis) {
        return switch (axis) {
            case Axis.X -> Math.sqrt(vec.y * vec.y + vec.z * vec.z);
            case Axis.Y -> Math.sqrt(vec.x * vec.x + vec.z * vec.z);
            case Axis.Z -> Math.sqrt(vec.x * vec.x + vec.y * vec.y);
            default -> 0.0;
        };
    }

    public static void includeMaxRotationInBox(ABB box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        double rotation = coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        BoxUtils.includeMaxRotationInBox(box, vec, axis, rotation, coordinator.getRotationMatrix(axis), coordinator.translation);
    }

    public static void includeMaxRotationInBoxInverse(ABB box, Vec3d vec, Axis axis, CollisionCoordinator coordinator) {
        Vec3d translation;
        double rotation = -coordinator.getRotationDegree(axis);
        if (rotation == 0.0) {
            return;
        }
        if (coordinator.translation != null) {
            translation = new Vec3d(coordinator.translation);
            translation.invert();
        } else {
            translation = null;
        }
        BoxUtils.includeMaxRotationInBox(box, vec, axis, rotation, coordinator.getRotationMatrixInv(axis), translation);
    }

    private static void includeMaxRotationInBox(ABB box, Vec3d vec, Axis axis, double rotation, Matrix3 matrix, Vec3d translation) {
        Facing facing;
        int quarterRotation;
        Double length = null;
        BooleanRotation state = BooleanRotation.get(axis, vec);
        boolean positive = rotation > 0.0;
        if (rotation >= 90.0) {
            for (quarterRotation = 90; (double)quarterRotation <= Math.abs(rotation) && quarterRotation < 360; quarterRotation += 90) {
                Facing facing2 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
                if (length == null) {
                    length = BoxUtils.lengthIgnoreAxis(vec, axis);
                }
                box.include(facing, length);
                if (translation != null) {
                    box.include(facing, length + translation.get(facing.axis));
                }
                state = state.clockwise();
            }
        }
        matrix.transform(vec);
        box.include(vec);
        if (quarterRotation <= 360 && !state.is(vec)) {
            Facing facing3 = facing = positive ? state.clockwiseMaxFacing() : state.counterMaxClockwiseFacing();
            if (length == null) {
                length = BoxUtils.lengthIgnoreAxis(vec, axis);
            }
            box.include(facing, length);
            if (translation != null) {
                box.include(facing, length + translation.get(facing.axis));
            }
        }
    }

    public static double get(class_238 bb, Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> bb.field_1320;
            case Facing.WEST -> bb.field_1323;
            case Facing.UP -> bb.field_1325;
            case Facing.DOWN -> bb.field_1322;
            case Facing.SOUTH -> bb.field_1324;
            case Facing.NORTH -> bb.field_1321;
        };
    }

    public static double min(class_238 bb, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> bb.field_1323;
            case class_2350.class_2351.field_11052 -> bb.field_1322;
            case class_2350.class_2351.field_11051 -> bb.field_1321;
        };
    }

    public static double max(class_238 bb, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> bb.field_1320;
            case class_2350.class_2351.field_11052 -> bb.field_1325;
            case class_2350.class_2351.field_11051 -> bb.field_1324;
        };
    }

    public static double min(class_238 bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.field_1323;
            case Axis.Y -> bb.field_1322;
            case Axis.Z -> bb.field_1321;
        };
    }

    public static double max(class_238 bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.field_1320;
            case Axis.Y -> bb.field_1325;
            case Axis.Z -> bb.field_1324;
        };
    }

    public static Vec3d corner(class_238 bb, BoxCorner corner) {
        return new Vec3d(BoxUtils.cornerX(bb, corner), BoxUtils.cornerY(bb, corner), BoxUtils.cornerZ(bb, corner));
    }

    public static double cornerValue(class_238 bb, BoxCorner corner, Axis axis) {
        return BoxUtils.get(bb, corner.getFacing(axis));
    }

    public static double cornerX(class_238 bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.x);
    }

    public static double cornerY(class_238 bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.y);
    }

    public static double cornerZ(class_238 bb, BoxCorner corner) {
        return BoxUtils.get(bb, corner.z);
    }

    public static boolean intersectsWithAxis(class_238 bb, class_238 other, Axis one, Axis two) {
        return bb.method_1001(one.toVanilla()) < other.method_990(one.toVanilla()) && bb.method_990(one.toVanilla()) > bb.method_1001(one.toVanilla()) && bb.method_1001(two.toVanilla()) < bb.method_990(two.toVanilla()) && bb.method_990(two.toVanilla()) > bb.method_1001(two.toVanilla());
    }

    public static boolean intersectsWithAxis(class_238 bb, Axis one, Axis two, double valueOne, double valueTwo) {
        return bb.method_1001(one.toVanilla()) < valueOne && bb.method_990(one.toVanilla()) > valueOne && bb.method_1001(two.toVanilla()) < valueTwo && bb.method_990(two.toVanilla()) > valueTwo;
    }

    public static double calculateAxisOffset(Axis axis, Axis one, Axis two, class_238 bb, class_238 other, double offset) {
        if (BoxUtils.intersectsWithAxis(bb, other, one, two)) {
            double newDistance;
            if (offset > 0.0 && other.method_990(axis.toVanilla()) <= bb.method_1001(axis.toVanilla())) {
                double newDistance2 = bb.method_1001(axis.toVanilla()) - other.field_1320;
                if (newDistance2 < offset) {
                    return newDistance2;
                }
            } else if (offset < 0.0 && other.method_1001(axis.toVanilla()) >= bb.method_990(axis.toVanilla()) && (newDistance = bb.method_990(axis.toVanilla()) - other.method_1001(axis.toVanilla())) > offset) {
                return newDistance;
            }
        }
        return offset;
    }
}

