/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.config.ClientConfig;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowType;
import com.github.mim1q.minecells.item.weapon.bow.LightningBoltItem;
import com.github.mim1q.minecells.item.weapon.interfaces.CritIndicator;
import com.github.mim1q.minecells.network.ClientPacketHandler;
import com.github.mim1q.minecells.registry.MineCellsItemGroups;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import dev.mim1q.gimm1q.client.highlight.HighlightDrawerCallback;
import dev.mim1q.gimm1q.client.highlight.crosshair.CrosshairTipDrawerCallback;
import dev.mim1q.gimm1q.client.item.handheld.HandheldItemModelRegistry;
import dev.mim1q.gimm1q.screenshake.ScreenShakeModifiers;
import draylar.omegaconfig.OmegaConfig;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MineCellsClient
implements ClientModInitializer {
    private static final class_2960 CRIT_CROSSHAIR = MineCells.createId("textures/gui/crosshair/crit_indicator.png");
    public static final ClientConfig CLIENT_CONFIG = (ClientConfig)OmegaConfig.register(ClientConfig.class);

    public void onInitializeClient() {
        CLIENT_CONFIG.save();
        MineCellsRenderers.init();
        MineCellsRenderers.initBlocks();
        MineCellsItemGroups.init();
        ClientPacketHandler.init();
        MineCellsParticles.initClient();
        if (MineCellsClient.CLIENT_CONFIG.keepOriginalGuiModels) {
            this.setupAllHandheldModels();
        }
        this.setupShieldHandheldModels();
        if (MineCellsClient.CLIENT_CONFIG.showCritIndicator) {
            this.setupCritIndicator();
        }
        this.loadArrowModels();
        this.loadMiscCustomModels();
        this.setupTentacleWeaponHighlighting();
        this.setupLightningBoltHighlighting();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> MineCellsClient.setupScreenShakeModifiers(MineCellsClient.CLIENT_CONFIG.screenShake.global));
    }

    private void loadMiscCustomModels() {
        ModelLoadingPlugin.register(context -> {
            List<class_2960> miscModels = Stream.of("conjunctivius/chain", "conjunctivius/dash_chain").map(it -> MineCells.createId("misc/" + it)).toList();
            context.addModels(miscModels);
        });
    }

    private void setupTentacleWeaponHighlighting() {
        HighlightDrawerCallback.EVENT.register((drawer, ctx) -> {
            class_1799 stack = ctx.player().method_6047();
            if (stack.method_31574((class_1792)MineCellsItems.TENTACLE)) {
                class_239 hitResult = MineCellsItems.TENTACLE.hitResult;
                if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
                    return;
                }
                if (hitResult.method_17783() == class_239.class_240.field_1331) {
                    drawer.highlightEntity(((class_3966)hitResult).method_17782(), 0, -5626389);
                    return;
                }
                drawer.highlightBlock(((class_3965)hitResult).method_17777(), 0, -5626389);
            }
        });
    }

    private void setupLightningBoltHighlighting() {
        HighlightDrawerCallback.EVENT.register((drawer, ctx) -> {
            class_1309 entity;
            class_1799 stack = ctx.player().method_6047();
            if (stack.method_31574(MineCellsItems.LIGHTNING_BOLT) && (entity = LightningBoltItem.getTargetedEntity(stack, ctx.player().method_37908())) != null) {
                int ticks = ctx.player().method_6048();
                int color = 0xFF000000 | LightningBoltItem.getLightningColor(ticks);
                drawer.highlightEntity((class_1297)entity, 0, color);
            }
        });
    }

    private void setupCritIndicator() {
        CrosshairTipDrawerCallback.register((drawer, ctx) -> {
            class_1799 stack = ctx.player().method_6047();
            class_1792 patt4513$temp = stack.method_7909();
            if (patt4513$temp instanceof CritIndicator) {
                class_3966 entityHitResult;
                class_1297 patt4777$temp;
                CritIndicator item = (CritIndicator)patt4513$temp;
                class_239 hitResult = class_310.method_1551().field_1765;
                class_1309 entity = null;
                if (hitResult instanceof class_3966 && (patt4777$temp = (entityHitResult = (class_3966)hitResult).method_17782()) instanceof class_1309) {
                    class_1309 livingEntity;
                    entity = livingEntity = (class_1309)patt4777$temp;
                }
                if (item.shouldShowCritIndicator(ctx.player(), entity, stack)) {
                    drawer.drawCrosshairTip(12, 0, 16, CRIT_CROSSHAIR);
                }
            }
        });
    }

    public static void setupScreenShakeModifiers(float d) {
        ScreenShakeModifiers.setModifier((String)"minecells:weapon_flint", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.weaponFlint));
        ScreenShakeModifiers.setModifier((String)"minecells:weapon_lightning_bolt", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.weaponLightningBolt));
        ScreenShakeModifiers.setModifier((String)"minecells:shield_block", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.shieldBlock));
        ScreenShakeModifiers.setModifier((String)"minecells:shield_parry", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.shieldParry));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_smash", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conjunctiviusSmash));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_roar", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conjunctiviusRoar));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_death", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conjunctiviusDeath));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_leap", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conciergeLeap));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_step", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conciergeStep));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_roar", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conciergeRoar));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_death", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.conciergeDeath));
        ScreenShakeModifiers.setModifier((String)"minecells:explosion", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake.explosion));
    }

    private void setupAllHandheldModels() {
        this.setupHandheldModel(MineCellsItems.ASSASSINS_DAGGER);
        this.setupHandheldModel(MineCellsItems.BROADSWORD);
        this.setupHandheldModel(MineCellsItems.BALANCED_BLADE);
        this.setupHandheldModel(MineCellsItems.BLOOD_SWORD);
        this.setupHandheldModel(MineCellsItems.CROWBAR);
        this.setupHandheldModel(MineCellsItems.FLINT);
        this.setupHandheldModel(MineCellsItems.HATTORIS_KATANA);
        this.setupHandheldModel(MineCellsItems.SPITE_SWORD);
        this.setupHandheldModel(MineCellsItems.CURSED_SWORD);
        this.setupHandheldModel(MineCellsItems.PHASER);
        this.setupHandheldModel(MineCellsItems.FROST_BLAST);
        this.setupHandheldModel(MineCellsItems.NUTCRACKER);
        this.setupHandheldModel((class_1792)MineCellsItems.TENTACLE);
    }

    private void setupHandheldModel(class_1792 weapon) {
        String name = class_7923.field_41178.method_10221((Object)weapon).method_12832();
        HandheldItemModelRegistry.getInstance().register(weapon, MineCells.createId("weapon/" + name), MineCells.createId(name));
    }

    private void setupShieldHandheldModels() {
        for (class_1792 shield : MineCellsItems.SHIELDS) {
            String name = class_7923.field_41178.method_10221((Object)shield).method_12832();
            HandheldItemModelRegistry.getInstance().register(shield, MineCells.createId(name), MineCells.createId("shield_3d/" + name));
        }
    }

    private void loadArrowModels() {
        ModelLoadingPlugin.register(context -> context.addModels(CustomArrowType.getAllNames().stream().map(it -> MineCells.createId("arrow/" + it)).toList()));
    }
}

