/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.block.portal;

import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.registry.MineCellsBlockEntities;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.TeleportUtils;
import com.github.mim1q.minecells.world.state.MineCellsData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class DoorwayPortalBlockEntity
extends class_2586 {
    private boolean upstream = false;
    private boolean clientVisited = false;
    private class_2338 posOverride = null;
    private List<class_5250> label = null;

    public DoorwayPortalBlockEntity(class_2338 pos, class_2680 state) {
        this(MineCellsBlockEntities.DOORWAY, pos, state);
    }

    protected DoorwayPortalBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public class_2960 getTexture() {
        return ((DoorwayPortalBlock)this.method_11010().method_26204()).type.texture;
    }

    public class_2960 getBackgroundTexture() {
        return ((DoorwayPortalBlock)this.method_11010().method_26204()).type.backgroundTexture;
    }

    public boolean hasClientVisited() {
        return this.clientVisited;
    }

    public void updateClientVisited() {
        if (this.field_11863 != null && this.field_11863.field_9236) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            boolean lastClientVisited = this.clientVisited;
            this.clientVisited = ((PlayerEntityAccessor)player).getMineCellsData().get(this.posOverride == null ? player.method_24515() : this.posOverride).hasVisitedDimension(((DoorwayPortalBlock)this.method_11010().method_26204()).type.dimension);
            if (lastClientVisited != this.clientVisited) {
                this.label = null;
            }
        }
    }

    public List<class_5250> getLabel() {
        String[] parts;
        if (this.label != null) {
            return this.label;
        }
        ArrayList<class_5250> result = new ArrayList<class_5250>();
        class_5250 text = class_2561.method_43471((String)((DoorwayPortalBlock)this.method_11010().method_26204()).type.dimension.translationKey);
        if (!this.hasClientVisited()) {
            text.method_10852((class_2561)class_2561.method_43470((String)"*"));
        }
        if ((parts = text.getString().split(" ")).length >= 4) {
            result.add(class_2561.method_43470((String)(parts[0] + " " + parts[1])));
            result.add(class_2561.method_43470((String)(parts[2] + " " + parts[3])));
        } else {
            result.add(text);
        }
        class_2338 portalPos = this.posOverride == null ? MathUtils.getClosestMultiplePosition((class_2382)this.method_11016(), 1024) : this.posOverride;
        result.add(class_2561.method_43470((String)("[x: " + portalPos.method_10263() + ", z: " + portalPos.method_10260() + "]")));
        this.label = result;
        return result;
    }

    public void method_38240(class_1799 stack) {
        super.method_38240(stack);
        stack.method_7911("BlockEntityTag").method_10544("posOverride", this.posOverride == null ? new class_2338(MathUtils.getClosestMultiplePosition((class_2382)this.field_11867, 1024)).method_10063() : this.posOverride.method_10063());
    }

    public boolean canPlayerEnter(class_1657 player) {
        if (player == null || this.field_11863 == null) {
            return false;
        }
        class_2338 pos = this.posOverride == null ? player.method_24515() : this.posOverride;
        MineCellsDimension targetDimension = ((DoorwayPortalBlock)this.method_11010().method_26204()).type.dimension;
        MineCellsData.PlayerData mineCellsData = ((PlayerEntityAccessor)player).getMineCellsData().get(pos);
        if (this.isDownstream()) {
            if (MineCellsDimension.of(this.field_11863) == MineCellsDimension.OVERWORLD) {
                if (targetDimension == MineCellsDimension.PRISONERS_QUARTERS) {
                    return true;
                }
                return mineCellsData.hasVisitedDimension(targetDimension);
            }
            return true;
        }
        return mineCellsData.getPortalData(MineCellsDimension.of(this.field_11863), targetDimension).isPresent();
    }

    public void teleportPlayer(class_3222 player, class_3218 world, MineCellsDimension targetDimension) {
        if (this.isDownstream()) {
            if (targetDimension == MineCellsDimension.OVERWORLD) {
                Optional<MineCellsData.PlayerData.PortalData> data = MineCellsData.getPlayerData(player, world, this.posOverride).getPortalData(MineCellsDimension.PRISONERS_QUARTERS, MineCellsDimension.OVERWORLD);
                data.ifPresent(portalData -> {
                    class_2338 pos = portalData.toPos();
                    TeleportUtils.teleportToDimension((class_1297)player, world.method_8503().method_30002(), class_243.method_24953((class_2382)pos), player.method_36454());
                });
            } else {
                MineCellsData.getPlayerData(player, world, this.posOverride).addPortalData(MineCellsDimension.of((class_1937)world), targetDimension, this.field_11867.method_10081(((class_2350)this.method_11010().method_11654((class_2769)DoorwayPortalBlock.FACING)).method_10163()), class_2338.method_49638((class_2374)targetDimension.getTeleportPosition(this.field_11867, world)));
                targetDimension.teleportPlayer(player, world, this.posOverride);
            }
        } else {
            Optional<MineCellsData.PlayerData.PortalData> data = MineCellsData.getPlayerData(player, world, this.posOverride).getPortalData(MineCellsDimension.of((class_1937)world), targetDimension);
            data.ifPresent(portalData -> {
                class_2338 pos = portalData.toPos();
                TeleportUtils.teleportToDimension((class_1297)player, targetDimension.getWorld(world), class_243.method_24953((class_2382)pos), player.method_36454());
            });
        }
    }

    public float getRotation() {
        return ((class_2350)this.method_11010().method_11654((class_2769)DoorwayPortalBlock.FACING)).method_10144();
    }

    public boolean isUpstream() {
        return this.upstream;
    }

    public boolean isDownstream() {
        return !this.isUpstream();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2338 getPosOverride() {
        return this.posOverride;
    }

    public void setPosOverride(class_2338 posOverride) {
        this.posOverride = posOverride;
        this.method_5431();
    }

    public void method_11014(class_2487 nbt) {
        this.upstream = nbt.method_10577("upstream");
        this.updateClientVisited();
        if (nbt.method_10545("posOverride")) {
            this.posOverride = class_2338.method_10092((long)nbt.method_10537("posOverride"));
        }
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10556("upstream", this.upstream);
        if (this.posOverride != null) {
            nbt.method_10544("posOverride", this.posOverride.method_10063());
        }
    }
}

