/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.model;

import com.github.mim1q.minecells.entity.boss.ConciergeEntity;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.animation.AnimationUtils;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.joml.Math;

public class ConciergeEntityModel
extends class_583<ConciergeEntity> {
    private boolean entityAlive = true;
    private final class_630 root;
    private final class_630 torsoLower;
    private final class_630 torsoUpper;
    private final class_630 neck;
    private final class_630 head;
    private final class_630 rightArm;
    private final class_630 leftArm;
    private final class_630 rightLeg;
    private final class_630 leftLeg;

    public ConciergeEntityModel(class_630 root) {
        this.root = root;
        this.torsoLower = root.method_32086("torso_lower");
        this.torsoUpper = this.torsoLower.method_32086("torso_upper");
        this.neck = this.torsoUpper.method_32086("neck");
        this.head = this.neck.method_32086("head");
        this.rightArm = this.torsoUpper.method_32086("right_arm");
        this.leftArm = this.torsoUpper.method_32086("left_arm");
        this.rightLeg = root.method_32086("right_leg");
        this.leftLeg = root.method_32086("left_leg");
    }

    public void setAngles(ConciergeEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.entityAlive = entity.method_5805();
        this.root.method_32088().forEach(class_630::method_41923);
        float idleProgress = 1.0f - limbDistance;
        this.animateIdle(animationProgress, idleProgress);
        if (limbDistance > 1.0E-5f) {
            this.animateWalk(limbAngle, limbDistance);
        }
        this.animateHead(headYaw, headPitch);
        AnimationUtils.animate(entity.leapChargeAnimation, this::animateLeapCharge, animationProgress);
        AnimationUtils.animate(entity.leapReleaseAnimation, this::animateLeapRelease, animationProgress);
        AnimationUtils.animate(entity.waveChargeAnimation, this::animateShockwaveCharge, animationProgress);
        AnimationUtils.animate(entity.waveReleaseAnimation, this::animateShockwaveRelease, animationProgress);
        AnimationUtils.animate(entity.punchChargeAnimation, this::animatePunchCharge, animationProgress);
        AnimationUtils.animate(entity.punchReleaseAnimation, this::animatePunchRelease, animationProgress);
        AnimationUtils.animate(entity.deathStartAnimation, this::animateDeathStart, animationProgress);
        AnimationUtils.animate(entity.deathFallAnimation, this::animateDeathFall, animationProgress);
        AnimationUtils.animate(entity.screamAnimation, delta -> this.animateShout(delta.floatValue(), animationProgress), animationProgress);
    }

    private void animateIdle(float animationProgress, float delta) {
        this.torsoUpper.field_3654 = MathUtils.radians(35.0f) + AnimationUtils.wobble(animationProgress, 0.1f, 5.0f * delta);
        this.torsoLower.field_3654 = MathUtils.radians(-5.0f) + AnimationUtils.wobble(animationProgress, 0.1f, 3.0f * delta, 15.0f);
        this.leftArm.field_3654 = this.rightArm.field_3654 = MathUtils.radians(-30.0f) + AnimationUtils.wobble(animationProgress, 0.1f, -10.0f * delta, 30.0f);
        this.rightArm.field_3675 = MathUtils.radians(15.0f);
        this.leftArm.field_3675 = MathUtils.radians(-15.0f);
    }

    private void animateWalk(float limbAngle, float limbDistance) {
        this.rightArm.field_3654 -= AnimationUtils.wobble(limbAngle, -0.5f, 90.0f * limbDistance, -20.0f);
        this.leftArm.field_3654 -= AnimationUtils.wobble(limbAngle, 0.5f, 90.0f * limbDistance, -20.0f);
        this.rightLeg.field_3654 = AnimationUtils.wobble(limbAngle, -0.5f, 60.0f * limbDistance);
        this.rightLeg.field_3656 -= Math.max((float)0.0f, (float)Math.sin((float)(limbAngle * 0.5f + MathUtils.radians(80.0f)))) * 4.0f * limbDistance;
        this.leftLeg.field_3654 = AnimationUtils.wobble(limbAngle, 0.5f, 60.0f * limbDistance);
        this.leftLeg.field_3656 -= Math.max((float)0.0f, (float)Math.sin((float)(limbAngle * 0.5f - MathUtils.radians(100.0f)))) * 4.0f * limbDistance;
        this.torsoLower.field_3654 += AnimationUtils.wobble(limbAngle, 1.0f, 10.0f * limbDistance);
        this.torsoLower.field_3675 = AnimationUtils.wobble(limbAngle, 0.5f, 20.0f * limbDistance);
        this.torsoLower.field_3656 += Math.abs((float)Math.sin((float)(limbAngle * 0.5f + MathUtils.radians(180.0f)))) * 3.0f * limbDistance;
        this.torsoUpper.field_3654 += AnimationUtils.wobble(limbAngle, 1.0f, 10.0f * limbDistance);
        this.torsoUpper.field_3675 = AnimationUtils.wobble(limbAngle, 0.5f, 20.0f * limbDistance, 15.0f);
        this.torsoUpper.field_3674 = AnimationUtils.wobble(limbAngle, 0.5f, 10.0f * limbDistance, 30.0f);
    }

    private void animateHead(float headYaw, float headPitch) {
        this.neck.field_3654 = -0.8f * (this.torsoLower.field_3654 + this.torsoUpper.field_3654);
        this.neck.field_3675 = -0.9f * this.torsoUpper.field_3675;
        this.head.field_3675 = MathUtils.radians(headYaw);
        this.head.field_3654 = MathUtils.radians(headPitch);
    }

    private void animateLeapCharge(float delta) {
        AnimationUtils.lerpAngles(this.torsoLower, 30.0f, 0.0f, 20.0f, delta);
        this.torsoLower.field_3656 += 7.0f * delta;
        AnimationUtils.lerpAngles(this.torsoUpper, 30.0f, 0.0f, -10.0f, delta);
        AnimationUtils.lerpAngles(this.leftArm, -60.0f, 0.0f, -30.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, -30.0f, 0.0f, 20.0f, delta);
        this.rightArm.field_3656 -= 2.0f * delta;
        AnimationUtils.lerpAngles(this.rightLeg, 15.0f, 0.0f, 0.0f, delta);
        this.rightLeg.field_3655 -= 10.0f * delta;
        AnimationUtils.lerpAngles(this.leftLeg, 60.0f, 20.0f, 10.0f, delta);
        this.leftLeg.field_3656 += 8.0f * delta;
        this.leftLeg.field_3655 -= 10.0f * delta;
        this.head.field_3654 += MathUtils.radians(20.0f) * delta;
    }

    private void animateLeapRelease(float delta) {
        double leapReleaseLimbs = 1.0 - (double)delta * 0.5;
        this.torsoLower.field_3654 += MathUtils.radians(5.0f) * delta;
        this.torsoUpper.field_3654 -= MathUtils.radians(5.0f) * delta;
        this.leftArm.field_3674 -= MathUtils.radians(25.0f) * delta;
        this.rightArm.field_3674 += MathUtils.radians(25.0f) * delta;
        this.head.field_3654 += MathUtils.radians(40.0f) * delta;
        this.rightLeg.field_3654 = (float)((double)this.rightLeg.field_3654 * leapReleaseLimbs);
        this.leftLeg.field_3654 = (float)((double)this.leftLeg.field_3654 * leapReleaseLimbs);
        this.leftArm.field_3654 = (float)((double)this.leftArm.field_3654 * leapReleaseLimbs);
        this.rightArm.field_3654 = (float)((double)this.rightArm.field_3654 * leapReleaseLimbs);
    }

    private void animateShockwaveCharge(float delta) {
        AnimationUtils.lerpAngles(this.torsoLower, -10.0f, 30.0f, -25.0f, delta);
        this.torsoLower.field_3656 += 2.0f * delta;
        AnimationUtils.lerpAngles(this.torsoUpper, -15.0f, 10.0f, -25.0f, delta);
        this.torsoUpper.field_3656 += 3.0f * delta;
        AnimationUtils.lerpAngles(this.rightArm, 0.0f, 20.0f, 60.0f, delta);
        AnimationUtils.lerpAngles(this.leftArm, 15.0f, 0.0f, 0.0f, delta);
        this.leftLeg.field_3655 -= 3.0f * delta;
        AnimationUtils.lerpAngles(this.neck, 0.0f, -45.0f, 30.0f, delta);
    }

    private void animateShockwaveRelease(float delta) {
        AnimationUtils.lerpAngles(this.torsoLower, 0.0f, 15.0f, 0.0f, delta);
        AnimationUtils.lerpAngles(this.torsoUpper, 15.0f, -20.0f, 0.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, -90.0f, -30.0f, 60.0f, delta);
        AnimationUtils.lerpAngles(this.leftArm, 40.0f, 0.0f, 0.0f, delta);
    }

    private void animatePunchCharge(float delta) {
        AnimationUtils.lerpAngles(this.torsoLower, 0.0f, 15.0f, 0.0f, delta);
        AnimationUtils.lerpAngles(this.torsoUpper, -10.0f, 10.0f, 0.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, -45.0f, 0.0f, 30.0f, delta);
        this.rightArm.field_3656 -= 4.0f * delta;
        this.rightArm.field_3655 += 4.0f * delta;
        this.rightLeg.field_3655 += 2.0f * delta;
        this.leftLeg.field_3655 -= 2.0f * delta;
        this.neck.field_3675 -= MathUtils.radians(10.0f) * delta;
        this.neck.field_3654 += MathUtils.radians(15.0f) * delta;
    }

    private void animatePunchRelease(float delta) {
        AnimationUtils.lerpAngles(this.torsoLower, 20.0f, -10.0f, 0.0f, delta);
        this.torsoLower.field_3656 += 3.0f * delta;
        AnimationUtils.lerpAngles(this.torsoUpper, 15.0f, -10.0f, 0.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, -80.0f, 0.0f, -10.0f, delta);
        this.rightArm.field_3656 += 2.0f * delta;
        this.rightArm.field_3655 -= 4.0f * delta;
        AnimationUtils.lerpAngles(this.leftArm, 20.0f, 0.0f, -20.0f, delta);
        this.rightLeg.field_3655 -= 2.0f * delta;
        AnimationUtils.lerpAngles(this.leftLeg, 25.0f, 0.0f, 0.0f, delta);
        this.leftLeg.field_3656 += 2.0f * delta;
        this.leftLeg.field_3655 += 2.0f * delta;
    }

    private void animateDeathStart(float delta) {
        float bounceDelta = MathUtils.easeOutBounce(0.0f, 1.0f, delta);
        float spedUpDelta = MathUtils.easeInOutQuad(0.0f, 1.0f, Math.min((float)1.0f, (float)(delta * 2.0f)));
        AnimationUtils.lerpAngles(this.torsoLower, -10.0f, 0.0f, 0.0f, delta);
        this.torsoLower.field_3656 += 17.0f * bounceDelta;
        AnimationUtils.lerpAngles(this.torsoUpper, 40.0f, 0.0f, 0.0f, bounceDelta);
        AnimationUtils.lerpAngles(this.leftArm, -50.0f, 0.0f, -15.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, -50.0f, 0.0f, 15.0f, delta);
        AnimationUtils.lerpAngles(this.leftLeg, 85.0f, 15.0f, 0.0f, spedUpDelta);
        this.leftLeg.field_3656 += 17.0f * bounceDelta;
        this.leftLeg.field_3655 -= 4.0f * delta;
        AnimationUtils.lerpAngles(this.rightLeg, 85.0f, -15.0f, 0.0f, spedUpDelta);
        this.rightLeg.field_3656 += 17.0f * bounceDelta;
        this.rightLeg.field_3655 -= 4.0f * delta;
    }

    private void animateDeathFall(float delta) {
        float bounceDelta = MathUtils.easeOutBounce(0.0f, 1.0f, delta);
        float spedUpDelta = MathUtils.easeInOutQuad(0.0f, 1.0f, Math.min((float)1.0f, (float)(delta * 2.5f)));
        AnimationUtils.lerpAngles(this.torsoLower, 80.0f, 0.0f, 0.0f, bounceDelta);
        this.torsoLower.field_3655 -= 2.0f * delta;
        AnimationUtils.lerpAngles(this.torsoUpper, 10.0f, 0.0f, 0.0f, bounceDelta);
        AnimationUtils.lerpAngles(this.leftArm, -5.0f, 0.0f, -40.0f, spedUpDelta);
        AnimationUtils.lerpAngles(this.rightArm, -5.0f, 0.0f, 40.0f, spedUpDelta);
        AnimationUtils.lerpAngles(this.head, -10.0f, 110.0f, 10.0f, bounceDelta);
        AnimationUtils.lerpAngles(this.neck, 0.0f, 0.0f, 0.0f, delta);
        this.head.field_3657 += 2.0f * spedUpDelta;
        this.head.field_3656 -= 5.0f * spedUpDelta;
        this.head.field_3655 += 1.0f * spedUpDelta;
    }

    private void animateShout(float delta, float animationProgress) {
        float torsoYaw = 5.0f * Math.sin((float)(animationProgress * 0.2f - 0.1f));
        float upperTorsoYaw = 10.0f * Math.sin((float)(animationProgress * 0.2f));
        AnimationUtils.lerpAngles(this.torsoLower, 30.0f, torsoYaw, 0.0f, delta);
        AnimationUtils.lerpAngles(this.torsoUpper, -10.0f, upperTorsoYaw, 0.0f, delta);
        AnimationUtils.lerpAngles(this.rightArm, 25.0f, 0.0f, 25.0f, delta);
        AnimationUtils.lerpAngles(this.leftArm, 25.0f, 0.0f, -25.0f, delta);
        this.head.field_3675 += MathUtils.radians(3.0f) * Math.sin((float)(animationProgress * 6.0f)) * delta;
        this.head.field_3654 += MathUtils.radians(2.0f) * Math.sin((float)(animationProgress * 4.0f)) * delta;
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        int overlayUv = this.entityAlive ? overlay : class_4608.field_21444;
        this.root.method_22699(matrices, vertices, light, overlayUv, red, green, blue, alpha);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        modelPartData.method_32117("right_leg", class_5606.method_32108().method_32101(24, 65).method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 24.0f, 6.0f, new class_5605(0.0f)), class_5603.method_32090((float)-5.0f, (float)2.0f, (float)0.0f));
        class_5610 torsoLower = modelPartData.method_32117("torso_lower", class_5606.method_32108().method_32101(0, 42).method_32098(-7.0f, -18.0f, -4.0f, 14.0f, 10.0f, 8.0f, new class_5605(0.0f)).method_32101(0, 26).method_32098(-8.0f, -8.0f, -5.0f, 16.0f, 6.0f, 10.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)2.0f, (float)0.0f));
        class_5610 torsoUpper = torsoLower.method_32117("torso_upper", class_5606.method_32108().method_32101(0, 0).method_32098(-11.0f, -14.0f, -9.5f, 22.0f, 14.0f, 12.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-16.0f, (float)2.5f));
        torsoUpper.method_32117("cube_r1", class_5606.method_32108().method_32101(67, 36).method_32098(-2.0f, -4.0f, 0.0f, 2.0f, 5.0f, 6.0f, new class_5605(0.0f)), class_5603.method_32091((float)-4.0f, (float)-10.0f, (float)2.5f, (float)0.5236f, (float)-0.2618f, (float)0.0f));
        torsoUpper.method_32117("cube_r2", class_5606.method_32108().method_32101(67, 36).method_32096().method_32098(0.0f, -4.0f, 0.0f, 2.0f, 5.0f, 6.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32091((float)4.0f, (float)-10.0f, (float)2.5f, (float)0.5236f, (float)0.2618f, (float)0.0f));
        class_5610 neck = torsoUpper.method_32117("neck", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)-11.0f, (float)-8.5f));
        neck.method_32117("head", class_5606.method_32108().method_32101(59, 17).method_32098(-3.5f, -8.0f, -8.0f, 7.0f, 10.0f, 9.0f, new class_5605(0.0f)).method_32101(68, 0).method_32098(-2.5f, -14.0f, -8.0f, 5.0f, 6.0f, 9.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        torsoUpper.method_32117("right_arm", class_5606.method_32108().method_32101(66, 63).method_32098(-6.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new class_5605(0.0f)).method_32101(0, 60).method_32098(-5.0f, 2.0f, -3.0f, 6.0f, 28.0f, 6.0f, new class_5605(0.0f)).method_32101(44, 42).method_32098(-6.0f, 13.0f, -3.5f, 8.0f, 22.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32090((float)-11.0f, (float)-11.0f, (float)-2.5f));
        torsoUpper.method_32117("left_arm", class_5606.method_32108().method_32101(66, 63).method_32096().method_32098(-2.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new class_5605(0.0f)).method_32106(false).method_32101(0, 60).method_32096().method_32098(-1.0f, 2.0f, -3.0f, 6.0f, 28.0f, 6.0f, new class_5605(0.0f)).method_32106(false).method_32101(44, 42).method_32096().method_32098(-2.0f, 13.0f, -3.5f, 8.0f, 22.0f, 7.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)11.0f, (float)-11.0f, (float)-2.5f));
        modelPartData.method_32117("left_leg", class_5606.method_32108().method_32101(24, 65).method_32096().method_32098(-3.0f, -2.0f, -3.0f, 6.0f, 24.0f, 6.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)5.0f, (float)2.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }
}

