/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.dimension;

import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import java.util.HashMap;
import java.util.function.BiPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class MineCellsDimensionGraph {
    private final HashMap<MineCellsDimension, Node> dimensionGraph = new HashMap();

    private Node add(MineCellsDimension dimension, Node ... upstreamNodes) {
        Node node = new Node(dimension, upstreamNodes);
        this.dimensionGraph.put(dimension, node);
        return node;
    }

    public MineCellsDimensionGraph() {
        Node overworld = this.add(MineCellsDimension.OVERWORLD, new Node[0]);
        Node prisonersQuarters = this.add(MineCellsDimension.PRISONERS_QUARTERS, overworld);
        Node promenadeOfTheCondemned = this.add(MineCellsDimension.PROMENADE_OF_THE_CONDEMNED, prisonersQuarters);
        Node insufferableCrypt = this.add(MineCellsDimension.INSUFFERABLE_CRYPT, prisonersQuarters);
        Node ramparts = this.add(MineCellsDimension.RAMPARTS, promenadeOfTheCondemned);
        Node blackBridge = this.add(MineCellsDimension.BLACK_BRIDGE, ramparts);
    }

    public boolean canTraverseToOverworld(MineCellsDimension dimension, BiPredicate<MineCellsDimension, MineCellsDimension> predicate) {
        Node node = this.dimensionGraph.get((Object)dimension);
        return node != null && node.canTraverseToOverworld(predicate);
    }

    public void saveStuckPlayer(class_3222 player) {
        boolean stuck;
        if (!MineCellsDimension.isMineCellsDimension(player.method_37908())) {
            return;
        }
        boolean bl = stuck = !this.canTraverseToOverworld(MineCellsDimension.of(player.method_37908()), (from, to) -> ((PlayerEntityAccessor)player).getCurrentMineCellsPlayerData().getPortalData((MineCellsDimension)((Object)from), (MineCellsDimension)((Object)to)).isPresent());
        if (stuck) {
            player.field_13995.execute(() -> {
                player.method_43496((class_2561)class_2561.method_43471((String)"chat.minecells.stuck_message"));
                class_5321<class_1937> spawnDimension = player.method_26281();
                class_2338 spawnPos = player.method_26280();
                if (spawnDimension == null || spawnPos == null) {
                    spawnDimension = MineCellsDimension.OVERWORLD.key;
                    spawnPos = player.method_37908().method_43126();
                }
                player.method_14251(player.field_13995.method_3847(spawnDimension), (double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260(), player.method_36454(), player.method_36455());
            });
        }
    }

    private record Node(MineCellsDimension dimension, Node[] upstreamNodes) {
        public boolean canTraverseToOverworld(BiPredicate<MineCellsDimension, MineCellsDimension> predicate) {
            if (this.dimension == MineCellsDimension.OVERWORLD) {
                return true;
            }
            for (Node upstream : this.upstreamNodes) {
                if (!predicate.test(this.dimension, upstream.dimension) || !upstream.canTraverseToOverworld(predicate)) continue;
                return true;
            }
            return false;
        }
    }
}

