/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import com.github.mim1q.minecells.world.MineCellsExplosion;
import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1395;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class KamikazeEntity
extends MineCellsEntity {
    public AnimationProperty rotation = new AnimationProperty(180.0f);
    private static final class_2940<Integer> FUSE = class_2945.method_12791(KamikazeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(KamikazeEntity.class, (class_2941)class_2943.field_13323);

    public KamikazeEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 0, true);
        this.method_5875(true);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FUSE, (Object)-1);
        this.field_6011.method_12784(SLEEPING, (Object)true);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(3, (class_1352)new KamikazeFlyGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(0, (class_1352)new KamikazeAttackGoal(this, 1.0, 3.0));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 0, true, true, null));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.method_23327(this.method_23317(), this.method_23318() + 0.25, this.method_23321());
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    protected void clientTick() {
        if (this.method_6113()) {
            this.rotation.setupTransitionTo(180.0f, 0.1f);
        } else {
            this.rotation.setupTransitionTo(0.0f, 20.0f);
        }
    }

    protected void serverTick() {
        int fuse = this.getFuse();
        if (fuse == 0 && this.method_5805()) {
            this.explode();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), MineCellsSounds.KAMIKAZE_DEATH, class_3419.field_15251, 1.0f, 1.0f);
            this.method_31472();
        }
        this.setFuse(fuse - 1);
    }

    public void explode() {
        if (!this.method_37908().method_8608()) {
            MineCellsExplosion.explode((class_3218)this.method_37908(), (class_1297)this, (class_1309)this, this.method_19538(), 20.0f, 6.0f);
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 navigation = new class_1407((class_1308)this, world);
        navigation.method_6332(false);
        navigation.method_6354(false);
        navigation.method_6331(true);
        return navigation;
    }

    public int getFuse() {
        return (Integer)this.field_6011.method_12789(FUSE);
    }

    public void setFuse(int fuse) {
        this.field_6011.method_12778(FUSE, (Object)fuse);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    @Override
    protected class_3414 method_6002() {
        return MineCellsSounds.KAMIKAZE_DEATH;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("sleeping", this.method_6113());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSleeping(nbt.method_10577("sleeping"));
    }

    public static class_5132.class_5133 createKamikazeAttributes() {
        return KamikazeEntity.method_26827().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23720, 3.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23722, 0.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23716, 2.0);
    }

    public static class KamikazeFlyGoal
    extends class_1395 {
        protected final KamikazeEntity entity;

        public KamikazeFlyGoal(KamikazeEntity entity, double d) {
            super((class_1314)entity, d);
            this.entity = entity;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.entity.method_6113();
        }
    }

    public static class KamikazeAttackGoal
    extends class_1352 {
        protected final KamikazeEntity entity;
        protected final double speed;
        protected final double distance;

        public KamikazeAttackGoal(KamikazeEntity entity, double speed, double distance) {
            this.entity = entity;
            this.speed = speed;
            this.distance = distance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.entity.method_5968() != null;
        }

        public boolean method_6266() {
            return this.entity.method_5968() != null && this.entity.method_5968().method_5805();
        }

        public void method_6269() {
            this.entity.setSleeping(false);
            this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), MineCellsSounds.KAMIKAZE_WAKE, class_3419.field_15251, 1.0f, 1.0f);
        }

        public void method_6270() {
        }

        public void method_6268() {
            class_1309 target = this.entity.method_5968();
            if (target != null) {
                class_243 pos = target.method_19538();
                this.entity.method_5962().method_6239(pos.field_1352, pos.field_1351 + 1.5, pos.field_1350, this.speed);
                this.entity.method_5988().method_35111((class_1297)target);
                if ((double)this.entity.method_5739((class_1297)target) <= this.distance && this.entity.getFuse() < 0) {
                    this.entity.setFuse(30);
                    this.entity.method_37908().method_43128(null, this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321(), MineCellsSounds.KAMIKAZE_CHARGE, class_3419.field_15251, 1.0f, 1.0f);
                }
            }
        }

        public boolean method_38846() {
            return true;
        }
    }
}

