/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.bow;

import com.github.mim1q.minecells.entity.nonliving.projectile.CustomArrowEntity;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowType;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.TextUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CustomBowItem
extends class_1811 {
    private static final int MAX_USE_TIME = 72000;
    protected final CustomArrowType arrowType;
    protected final int maxProjectileCount;

    protected CustomBowItem(class_1792.class_1793 settings, CustomArrowType arrowType, int maxProjectileCount) {
        super(settings);
        this.arrowType = arrowType;
        this.maxProjectileCount = maxProjectileCount;
    }

    public CustomBowItem(class_1792.class_1793 settings, CustomArrowType arrowType) {
        this(settings, arrowType, 1);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (world.field_9236) {
            return;
        }
        int ticks = this.method_7881(stack) - remainingUseTicks;
        if (ticks < this.getDrawTime(stack) || !user.method_31747()) {
            return;
        }
        int loaded = this.loadMaxProjectiles(world, (class_1657)user, stack, user.method_18808(stack), this.maxProjectileCount);
        CustomBowItem.setLoadedProjectiles(stack, loaded);
        this.shoot(world, user, stack);
        stack.method_7956(1, user, player -> player.method_20236(user.method_6058()));
    }

    protected void shoot(class_1937 world, class_1309 user, class_1799 stack) {
        world.method_8396(null, user.method_24515(), MineCellsSounds.BOW_RELEASE, class_3419.field_15248, 0.5f, 0.9f);
        class_243 velocity = user.method_5828(1.0f);
        this.spawnArrow(world, (class_1657)user, stack, velocity);
        CustomBowItem.setLoadedProjectiles(stack, 0);
    }

    protected CustomArrowEntity spawnArrow(class_1937 world, class_1657 user, class_1799 stack, class_243 velocity) {
        CustomArrowEntity arrow = new CustomArrowEntity(world, user, this.arrowType, user.method_33571(), stack);
        arrow.method_7485(velocity.method_10216(), velocity.method_10214(), velocity.method_10215(), this.arrowType.getSpeed(), this.arrowType.getSpread());
        world.method_8649((class_1297)arrow);
        return arrow;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        boolean hasProjectile;
        class_1799 stack = user.method_5998(hand);
        class_1799 projectileStack = user.method_18808(stack);
        boolean projectileNeeded = this.arrowType.getAmmoItem().isPresent();
        boolean bl = hasProjectile = !projectileStack.method_7960();
        if (hasProjectile || !projectileNeeded) {
            world.method_8396(null, user.method_24515(), MineCellsSounds.BOW_CHARGE, class_3419.field_15248, 0.5f, 0.8f);
            user.method_6019(hand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22431((Object)stack);
    }

    public Predicate<class_1799> method_19268() {
        return item -> this.arrowType.getAmmoItem().map(arrow -> item.method_7909() == arrow).orElse(true);
    }

    protected final int loadMaxProjectiles(class_1937 world, class_1657 user, class_1799 bow, class_1799 arrow, int maxCount) {
        if (user.method_7337() || world.field_9236 || arrow.method_7960() || this.arrowType.getAmmoItem().isEmpty()) {
            return maxCount;
        }
        for (int i = 0; i < maxCount; ++i) {
            if (arrow.method_7960()) {
                return i;
            }
            arrow.method_7934(1);
        }
        return maxCount;
    }

    public int method_24792() {
        return 100;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public int getDrawTime(class_1799 stack) {
        return this.arrowType.getDrawTime();
    }

    public float getFovMultiplier(class_1657 player, class_1799 stack) {
        float multiplier = (float)player.method_6048() / (float)this.getDrawTime(stack);
        multiplier = multiplier > 1.0f ? 1.0f : (multiplier *= multiplier);
        return 1.0f - multiplier * 0.15f;
    }

    public static int getLoadedProjectiles(class_1799 bow) {
        CustomBowItem bowItem = (CustomBowItem)bow.method_7909();
        return bowItem.maxProjectileCount == 1 ? 1 : bow.method_7948().method_10550("LoadedProjectiles");
    }

    public static void setLoadedProjectiles(class_1799 bow, int count) {
        CustomBowItem bowItem = (CustomBowItem)bow.method_7909();
        if (bowItem.maxProjectileCount == 1) {
            return;
        }
        bow.method_7948().method_10569("LoadedProjectiles", count);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        TextUtils.addDescription(tooltip, this.method_7876() + ".description", Float.valueOf(this.arrowType.getAdditionalCritDamage()));
    }
}

