/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.mixin.entity.player;

import com.github.mim1q.minecells.accessor.LivingEntityAccessor;
import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.effect.MineCellsEffectFlags;
import com.github.mim1q.minecells.item.weapon.interfaces.CrittingWeapon;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.world.state.MineCellsData;
import com.github.mim1q.minecells.world.state.PlayerSpecificMineCellsData;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityAccessor {
    private static final class_2940<Integer> CELL_AMOUNT = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13327);
    private int kingdomPortalCooldown = 0;
    private int balancedBladeStacks = 0;
    private int balancedBladeTimer = 0;
    private int minecells$invincibilityFrames = 0;
    private PlayerSpecificMineCellsData mineCellsPlayerData = new PlayerSpecificMineCellsData(new class_2487());

    @Shadow
    public abstract void method_5783(class_3414 var1, float var2, float var3);

    @Shadow
    public abstract int method_6110();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(CELL_AMOUNT, (Object)0);
    }

    @Override
    public int getCells() {
        return (Integer)this.field_6011.method_12789(CELL_AMOUNT);
    }

    @Override
    public void setCells(int amount) {
        this.field_6011.method_12778(CELL_AMOUNT, (Object)amount);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.kingdomPortalCooldown > 0) {
            --this.kingdomPortalCooldown;
        }
        if (this.balancedBladeTimer > 0) {
            --this.balancedBladeTimer;
        } else {
            this.balancedBladeStacks = 0;
        }
        if (this.minecells$invincibilityFrames > 0) {
            --this.minecells$invincibilityFrames;
        }
    }

    @Override
    public PlayerSpecificMineCellsData getMineCellsData() {
        return this.mineCellsPlayerData;
    }

    @Override
    public MineCellsData.PlayerData getCurrentMineCellsPlayerData() {
        return this.mineCellsPlayerData.get(this.method_24515());
    }

    @Override
    public void setMineCellsData(PlayerSpecificMineCellsData data) {
        this.mineCellsPlayerData = data;
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void minecells$isInvulnerableTo(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecells$invincibilityFrames > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=1), ordinal=0)
    private float modifyDamage(float original, class_1297 target) {
        class_1799 stack = this.method_6047();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CrittingWeapon) {
            class_1309 livingTarget;
            CrittingWeapon critWeapon = (CrittingWeapon)class_17922;
            if (target instanceof class_1309 && critWeapon.canCrit(stack, livingTarget = (class_1309)target, this)) {
                if (critWeapon.shouldPlayCritSound(stack, livingTarget, this)) {
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), MineCellsSounds.CRIT, class_3419.field_15248, 1.0f, 1.0f);
                }
                return original + critWeapon.getAdditionalCritDamage(stack, livingTarget, this);
            }
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void minecells$injectDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.balancedBladeStacks = 0;
    }

    @Inject(method={"isBlockBreakingRestricted"}, at={@At(value="HEAD")}, cancellable=true)
    public void isBlockBreakingRestricted(class_1937 world, class_2338 pos, class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        if (((LivingEntityAccessor)((Object)this)).getMineCellsFlag(MineCellsEffectFlags.DISARMED)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="TAIL")})
    protected void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("cells", this.getCells());
        nbt.method_10569("kingdomPortalCooldown", this.kingdomPortalCooldown);
    }

    @Inject(method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="TAIL")})
    protected void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.setCells(nbt.method_10550("cells"));
        this.kingdomPortalCooldown = nbt.method_10550("kingdomPortalCooldown");
    }

    @Override
    public void addBalancedBladeStack() {
        if (this.balancedBladeStacks < 9) {
            ++this.balancedBladeStacks;
        }
        this.balancedBladeTimer = 100;
    }

    @Override
    public int getBalancedBladeStacks() {
        return this.balancedBladeStacks;
    }

    @Override
    public void setInvincibilityFrames(int frames) {
        this.minecells$invincibilityFrames = frames;
    }
}

