/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.mixin.shield;

import com.github.mim1q.minecells.item.weapon.shield.CustomShieldItem;
import com.github.mim1q.minecells.item.weapon.shield.CustomShieldType;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class ShieldPlayerEntityMixin
extends class_1309 {
    @Unique
    private boolean minecells$shieldBlocking = false;
    @Unique
    private int minecells$lastBlockedTime = 0;
    @Unique
    private class_1309 minecells$lastBlockedEntity = null;

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract void method_5783(class_3414 var1, float var2, float var3);

    private ShieldPlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void minecells$onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecells$lastBlockedEntity == source.method_5529() && this.field_6012 - this.minecells$lastBlockedTime < 10) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.minecells$shieldBlocking) {
            this.minecells$shieldBlocking = false;
            return;
        }
        class_1799 activeItem = this.method_6030();
        class_1792 class_17922 = activeItem.method_7909();
        if (class_17922 instanceof CustomShieldItem) {
            float maxAngle;
            CustomShieldItem shield = (CustomShieldItem)class_17922;
            Float angleDifference = CustomShieldItem.getAngleDifference(this.getThis(), source);
            float parryTime = shield.shieldType.getParryTime();
            CustomShieldType.DamageContext damageContext = new CustomShieldType.DamageContext(source, this.getThis(), amount);
            boolean isParry = (float)this.method_6048() <= parryTime;
            float f = maxAngle = isParry ? shield.shieldType.getParryAngle() : shield.shieldType.getBlockAngle();
            if (angleDifference == null || angleDifference.floatValue() > maxAngle) {
                return;
            }
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15150, this.method_5634(), 1.0f, 1.0f);
            activeItem.method_7956(1, (class_1309)this.getThis(), player -> player.method_20236(player.method_6058()));
            if (isParry) {
                this.applyShieldEffects(shield.shieldType, damageContext, shield.shieldType::onParry, shield.shieldType::onMeleeParry, shield.shieldType::onRangedParry, true);
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), MineCellsSounds.CRIT, this.method_5634(), 1.0f, 1.0f);
                CustomShieldItem.setParried(activeItem, true);
                cir.setReturnValue((Object)false);
            } else {
                this.minecells$shieldBlocking = true;
                float reduction = shield.shieldType.getBlockDamageReduction();
                boolean result = this.method_5643(source, amount * (1.0f - reduction));
                this.applyShieldEffects(shield.shieldType, damageContext, shield.shieldType::onBlock, shield.shieldType::onMeleeBlock, shield.shieldType::onRangedBlock, false);
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Unique
    private void applyShieldEffects(CustomShieldType shieldType, CustomShieldType.DamageContext context, Consumer<CustomShieldType.DamageContext> baseEffect, Consumer<CustomShieldType.MeleeDamageContext> meleeEffect, Consumer<CustomShieldType.RangedDamageContext> rangedEffect, boolean isParry) {
        class_1309 entity;
        this.minecells$lastBlockedTime = this.field_6012;
        class_1297 class_12972 = context.source().method_5526();
        class_1309 class_13092 = this.minecells$lastBlockedEntity = class_12972 instanceof class_1309 ? (entity = (class_1309)class_12972) : null;
        if (this.method_37908().field_9236) {
            return;
        }
        baseEffect.accept(context);
        class_1282 source = context.source();
        class_2394 particle = shieldType.getParticle();
        if (particle != null) {
            class_3218 world = (class_3218)this.method_37908();
            class_243 particlePos = this.method_19538().method_1031(0.0, (double)this.method_17682() / 2.0, 0.0).method_1019(this.method_5720().method_1029().method_1021(0.5));
            world.method_14199(shieldType.getParticle(), particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215(), isParry ? 10 : 3, 0.2, 0.2, 0.2, 0.1);
        }
        String shakeModifier = isParry ? "minecells:shield_parry" : "minecells:shield_block";
        ScreenShakeUtils.applyShake((class_3222)((class_3222)this.getThis()), (float)1.0f, (int)20, (String)shakeModifier);
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)attacker;
            class_1297 sourceEntity = source.method_5526();
            if (sourceEntity instanceof class_1676) {
                class_1676 projectile = (class_1676)sourceEntity;
                rangedEffect.accept(context.toRanged(livingAttacker, projectile));
            } else {
                if (isParry) {
                    livingAttacker.method_18799(class_243.field_1353);
                    livingAttacker.method_6005(1.0, livingAttacker.method_23317() - this.method_23317(), livingAttacker.method_23321() - this.method_23321());
                    livingAttacker.method_5643(this.method_37908().method_48963().method_48802(this.getThis()), shieldType.getParryDamage());
                }
                meleeEffect.accept(context.toMelee(livingAttacker));
            }
        }
    }

    @Unique
    private class_1657 getThis() {
        return (class_1657)this;
    }
}

