/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.network;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.blockentity.CellCrafterBlockEntity;
import com.github.mim1q.minecells.entity.nonliving.TentacleWeaponEntity;
import com.github.mim1q.minecells.network.PacketIdentifiers;
import com.github.mim1q.minecells.network.c2s.CellCrafterCraftRequestC2SPacket;
import com.github.mim1q.minecells.network.c2s.RequestSyncMineCellsPlayerDataC2SPacket;
import com.github.mim1q.minecells.network.c2s.RequestUnlockedCellCrafterRecipesC2SPacket;
import com.github.mim1q.minecells.network.s2c.SendUnlockedCellCrafterRecipesS2CPacket;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.registry.MineCellsItems;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class ServerPacketHandler {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RequestSyncMineCellsPlayerDataC2SPacket.ID, RequestSyncMineCellsPlayerDataC2SPacket::apply);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PacketIdentifiers.USE_TENTACLE, (server, player, handler, buf, responseSender) -> {
            class_243 targetPos = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_1799 playerItem = player.method_6047();
            double maxDistance = (double)MineCells.COMMON_CONFIG.baseTentacleMaxDistance + 2.0;
            if (!playerItem.method_31574((class_1792)MineCellsItems.TENTACLE) || targetPos.method_1025(player.method_19538()) > maxDistance * maxDistance) {
                MineCells.LOGGER.warn("Invalid tentacle weapon use packet from player {}", (Object)player.method_5477().getString());
                return;
            }
            server.execute(() -> {
                TentacleWeaponEntity tentacle = TentacleWeaponEntity.create(player.method_37908(), (class_1657)player, targetPos);
                player.method_37908().method_8649((class_1297)tentacle);
                player.method_7357().method_7906((class_1792)MineCellsItems.TENTACLE, MineCellsItems.TENTACLE.getBaseAbilityCooldown(playerItem));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RequestUnlockedCellCrafterRecipesC2SPacket.ID, (server, player, handler, buf, responseSender) -> responseSender.sendPacket(SendUnlockedCellCrafterRecipesS2CPacket.ID, (class_2540)new SendUnlockedCellCrafterRecipesS2CPacket(player)));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CellCrafterCraftRequestC2SPacket.ID, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            class_2960 recipeId = buf.method_10810();
            server.execute(() -> {
                class_2586 blockEntity = player.method_37908().method_8321(pos);
                Optional recipe = server.method_3772().method_8130(recipeId);
                if (blockEntity instanceof CellCrafterBlockEntity) {
                    Object patt2848$temp;
                    CellCrafterBlockEntity cellCrafter = (CellCrafterBlockEntity)blockEntity;
                    if (recipe.isPresent() && (patt2848$temp = recipe.get()) instanceof CellForgeRecipe) {
                        CellForgeRecipe cellForgeRecipe = (CellForgeRecipe)patt2848$temp;
                        boolean canCraft = cellForgeRecipe.matches(player.method_31548(), player.method_37908());
                        if (!canCraft) {
                            MineCells.LOGGER.warn("Player {} tried to craft {} without having the required items", (Object)player.method_5477().getString(), (Object)cellForgeRecipe.method_8114().toString());
                            return;
                        }
                        class_1799 output = cellForgeRecipe.craft(player.method_31548(), player.method_37908().method_30349());
                        if (output == null) {
                            MineCells.LOGGER.warn("Player {} tried to craft {} but failed", (Object)player.method_5477().getString(), (Object)cellForgeRecipe.method_8114().toString());
                            return;
                        }
                        cellCrafter.setCooldown(10);
                        cellCrafter.addStack(output);
                    }
                }
            });
        });
    }
}

