/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.particle.electric;

import com.github.mim1q.minecells.particle.electric.ElectricParticleEffect;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ElectricParticle
extends class_4003 {
    private final class_4002 spriteProvider;
    private final class_243 direction;
    private final float pitch;
    private final float yaw;
    private float roll;
    private final int length;
    private final int color;
    private final float size;
    private final boolean isMainBranch;

    private ElectricParticle(class_4002 spriteProvider, class_638 clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_243 direction, int length, int color, float size, boolean isMainBranch) {
        super(clientWorld, x, y, z);
        this.spriteProvider = spriteProvider;
        this.direction = direction.method_1029();
        this.length = length;
        this.color = color;
        this.field_3847 = 6;
        this.size = size;
        this.isMainBranch = isMainBranch;
        this.yaw = (float)Math.asin((double)(-this.direction.field_1351));
        this.pitch = (float)Math.atan2((double)this.direction.field_1352, (double)this.direction.field_1350);
        this.roll = clientWorld.field_9229.method_43057() * 2.0f * (float)java.lang.Math.PI;
        this.method_34753(velocityX, velocityY, velocityZ);
        this.method_18141(spriteProvider.method_18139(clientWorld.field_9229));
    }

    public void method_3070() {
        this.method_3063(this.field_3874 + this.field_3852, this.field_3854 + this.field_3869, this.field_3871 + this.field_3850);
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }
        this.method_18141(this.spriteProvider.method_18139(this.field_3851.field_9229));
        if (this.length == 0) {
            return;
        }
        if (this.field_3866 == 1) {
            for (int i = 0; i < 3; ++i) {
                if (!(this.field_3851.field_9229.method_43057() < 0.5f)) continue;
                this.addSideBranch();
            }
            this.addNextMainBranch();
        }
    }

    private void addSideBranch() {
        float delta = this.field_3851.field_9229.method_43057();
        class_243 newPos = new class_243(this.field_3874, this.field_3854, this.field_3871).method_1019(this.direction.method_1021((double)(delta * this.size)));
        class_243 randomDirection = this.direction.method_49272(this.field_3851.field_9229, 2.0f);
        int randomLength = Math.min((int)(this.length - 1), (int)this.field_3851.field_9229.method_43048(3));
        this.field_3851.method_8406((class_2394)new ElectricParticleEffect(randomDirection, randomLength, this.color, this.size * 0.5f, false), newPos.field_1352, newPos.field_1351, newPos.field_1350, this.field_3852, this.field_3869, this.field_3850);
    }

    private void addNextMainBranch() {
        class_243 newDirection = this.direction.method_49272(this.field_3851.method_8409(), this.isMainBranch ? 0.1f : 2.0f);
        class_243 newPos = new class_243(this.field_3874, this.field_3854, this.field_3871).method_1019(this.direction.method_1021((double)this.size));
        this.field_3851.method_8406((class_2394)new ElectricParticleEffect(newDirection, this.length - 1, this.color, this.size, this.isMainBranch), newPos.field_1352, newPos.field_1351, newPos.field_1350, this.field_3852, this.field_3869, this.field_3850);
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        int i;
        float lifetimeDelta = ((float)this.field_3866 + tickDelta) / (float)this.field_3847;
        int alpha = 255;
        if ((double)lifetimeDelta < 0.2) {
            alpha = (int)((double)lifetimeDelta / 0.2 * 255.0);
        } else if ((double)lifetimeDelta > 0.8) {
            alpha = (int)((double)(1.0f - lifetimeDelta) / 0.2 * 255.0);
        }
        alpha = class_3532.method_15340((int)alpha, (int)0, (int)255);
        float px = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - camera.method_19326().field_1352);
        float py = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - camera.method_19326().field_1351);
        float pz = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - camera.method_19326().field_1350);
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateY(this.pitch);
        quaternionf.rotateX(this.yaw);
        quaternionf.rotateZ(this.roll);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-0.5f, 0.0f, 0.0f), new Vector3f(-0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 0.0f)};
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(this.size);
            vector3f.add(px, py, pz);
        }
        float k = this.method_18133();
        float l = this.method_18134();
        float m = this.method_18135();
        float n = this.method_18136();
        float[] u = new float[]{l, l, k, k};
        float[] v = new float[]{n, m, m, n};
        int o = 0xF000F0;
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        for (i = 0; i <= 3; ++i) {
            vertexConsumer.method_22912((double)vector3fs[i].x(), (double)vector3fs[i].y(), (double)vector3fs[i].z()).method_22913(u[i], v[i]).method_1336(r, g, b, alpha).method_22916(o).method_1344();
        }
        for (i = 3; i >= 0; --i) {
            vertexConsumer.method_22912((double)vector3fs[i].x(), (double)vector3fs[i].y(), (double)vector3fs[i].z()).method_22913(u[i], v[i]).method_1336(r, g, b, alpha).method_22916(o).method_1344();
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public record Factory(class_4002 spriteProvider) implements class_707<ElectricParticleEffect>
    {
        public class_703 createParticle(ElectricParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ElectricParticle(this.spriteProvider, world, x, y, z, velocityX, velocityY, velocityZ, parameters.direction(), parameters.length(), parameters.color(), parameters.size(), parameters.isMainBranch());
        }
    }
}

