/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.github.mim1q.minecells.structure.grid.GridPiece;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5819;

public class GridPiecesGenerator {
    public static List<GridPiece> generatePieces(class_2338 startPos, Optional<class_2902.class_2903> projectStartToHeightmap, class_3195.class_7149 context, int size, RoomGridGenerator generator) {
        List<RoomData> roomDataList = generator.generate(context);
        ArrayList<GridPiece> pieces = new ArrayList<GridPiece>();
        for (RoomData data : roomDataList) {
            if (projectStartToHeightmap.isPresent() && data.terrainFit) {
                pieces.add(GridPiecesGenerator.getTerrainFitPiece(data, startPos, projectStartToHeightmap, context, size));
                continue;
            }
            pieces.add(new GridPiece(context, data.poolId, startPos.method_10081(data.pos.method_35862(size)).method_10081(data.offset), data.rotation, size));
        }
        return pieces;
    }

    public static GridPiece getTerrainFitPiece(RoomData data, class_2338 startPos, Optional<class_2902.class_2903> projectStartToHeightmap, class_3195.class_7149 context, int size) {
        class_2338 pos = startPos.method_10081(data.terrainSamplePos.method_35862(size));
        class_2338 heightmapPos = pos.method_10081(data.terrainSampleOffset);
        Integer heightmapY = projectStartToHeightmap.map(type -> context.comp_562().method_20402(heightmapPos.method_10263(), heightmapPos.method_10260(), type, context.comp_569(), context.comp_564())).orElse(0);
        int heightDiff = heightmapY - startPos.method_10264();
        return new GridPiece(context, data.poolId, startPos.method_10081(data.pos.method_35862(size)).method_10081(data.offset).method_10069(0, heightDiff, 0), data.rotation, size);
    }

    public static abstract class RoomGridGenerator {
        protected final List<RoomData> rooms = new ArrayList<RoomData>();
        protected final Set<class_2382> usedPositions = new HashSet<class_2382>();

        protected abstract void addRooms(class_5819 var1);

        public List<RoomData> generate(class_3195.class_7149 context) {
            this.rooms.clear();
            this.usedPositions.clear();
            this.addRooms((class_5819)context.comp_566());
            return this.rooms;
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset, boolean terrainFit) {
            RoomData builder = RoomData.create(pos, poolId).rotation(rotation).offset(offset);
            if (terrainFit) {
                builder.terrainFit();
            }
            this.addRoom(builder);
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset) {
            this.addRoom(pos, rotation, poolId, offset, false);
        }

        protected final void addRoom(class_2382 pos, class_2470 rotation, class_2960 poolId) {
            this.addRoom(pos, rotation, poolId, class_2382.field_11176);
        }

        protected final void addTerrainFitRoom(class_2382 pos, class_2470 rotation, class_2960 poolId, class_2382 offset) {
            this.addRoom(pos, rotation, poolId, offset, true);
        }

        protected final void addTerrainFitRoom(class_2382 pos, class_2470 rotation, class_2960 poolId) {
            this.addTerrainFitRoom(pos, rotation, poolId, class_2382.field_11176);
        }

        protected void addRoom(RoomData roomData) {
            this.rooms.add(roomData);
            this.usedPositions.add(roomData.pos);
        }

        protected boolean isPositionUsed(class_2382 pos) {
            return this.usedPositions.contains(pos);
        }

        public static RoomGridGenerator single(class_2960 roomId) {
            return RoomGridGenerator.single(roomId, class_2382.field_11176);
        }

        public static RoomGridGenerator single(class_2960 roomId, class_2382 offset) {
            return new Single(roomId, offset);
        }

        protected static RoomData room(int x, int y, int z, class_2960 poolId) {
            return RoomData.create(x, y, z, poolId);
        }

        protected static RoomData room(class_2382 pos, class_2960 poolId) {
            return RoomData.create(pos, poolId);
        }

        public static final class Single
        extends RoomGridGenerator {
            private final class_2960 roomId;
            private final class_2382 offset;

            Single(class_2960 roomId, class_2382 offset) {
                this.roomId = roomId;
                this.offset = offset;
            }

            @Override
            protected void addRooms(class_5819 random) {
                this.addRoom(class_2382.field_11176, class_2470.method_16548((class_5819)random), this.roomId, this.offset);
            }
        }
    }

    public static class RoomData {
        public final class_2382 pos;
        public final class_2960 poolId;
        public class_2470 rotation = class_2470.field_11467;
        public class_2382 offset = class_2382.field_11176;
        public boolean terrainFit = false;
        public class_2382 terrainSamplePos;
        public class_2382 terrainSampleOffset = new class_2382(8, 0, 8);

        public RoomData(class_2382 pos, class_2960 poolId) {
            this.pos = pos;
            this.poolId = poolId;
            this.terrainSamplePos = pos;
        }

        public static RoomData create(class_2382 pos, class_2960 poolId) {
            return new RoomData(pos, poolId);
        }

        public static RoomData create(int x, int y, int z, class_2960 poolId) {
            return RoomData.create(new class_2382(x, y, z), poolId);
        }

        public RoomData rotation(class_2470 rotation) {
            this.rotation = rotation;
            return this;
        }

        public RoomData offset(class_2382 offset) {
            this.offset = offset;
            return this;
        }

        public RoomData offset(int x, int y, int z) {
            return this.offset(new class_2382(x, y, z));
        }

        public RoomData terrainFitOffset(int x, int y, int z) {
            this.offset(x, y, z);
            this.terrainSampleOffset = this.offset;
            this.terrainFit();
            return this;
        }

        public RoomData terrainFit() {
            this.terrainFit = true;
            return this;
        }

        public RoomData terrainFit(class_2382 pos) {
            this.terrainFit = true;
            this.terrainSamplePos = pos;
            return this;
        }

        public RoomData terrainFit(int x, int y, int z) {
            return this.terrainFit(new class_2382(x, y, z));
        }

        public RoomData terrainSampleOffset(int x, int y, int z) {
            this.terrainSampleOffset = new class_2382(x, y, z);
            return this;
        }
    }
}

