/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.util.animation;

import com.github.mim1q.minecells.util.MathUtils;
import net.minecraft.class_3532;

public class AnimationProperty {
    private float value;
    private float lastValue;
    private float targetValue;
    private float lastTime = 0.0f;
    private float time = 0.0f;
    private float duration = 10.0f;
    private EasingFunction easingFunction;

    public AnimationProperty(float value, EasingFunction easingFunction) {
        this.value = value;
        this.lastValue = value;
        this.targetValue = value;
        this.easingFunction = easingFunction;
    }

    public AnimationProperty(float value) {
        this(value, MathUtils::easeInOutQuad);
    }

    public void setupTransitionTo(float targetValue, float duration, EasingFunction easingFunction) {
        boolean result = this.setupTransitionTo(targetValue, duration);
        if (result) {
            this.easingFunction = easingFunction;
        }
    }

    public boolean setupTransitionTo(float targetValue, float duration) {
        if (targetValue == this.targetValue) {
            return false;
        }
        this.lastValue = this.value;
        this.lastTime = this.time;
        this.duration = duration;
        this.targetValue = targetValue;
        return true;
    }

    public float update(float time) {
        this.time = time;
        this.value = this.easingFunction.ease(this.lastValue, this.targetValue, this.getProgress());
        return this.getValue();
    }

    public float getProgress() {
        return class_3532.method_15363((float)((this.time - this.lastTime) / this.duration), (float)0.0f, (float)1.0f);
    }

    public float getValue() {
        return this.value;
    }

    @FunctionalInterface
    public static interface EasingFunction {
        public float ease(float var1, float var2, float var3);
    }
}

