/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.state;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.network.s2c.SyncMineCellsPlayerDataS2CPacket;
import com.github.mim1q.minecells.world.state.PlayerSpecificMineCellsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MineCellsData
extends class_18 {
    public final Map<Integer, RunData> runs = new HashMap<Integer, RunData>();
    private class_1657 wipeScheduledPlayer = null;
    private String lastMineCellsVersion = null;
    private String mineCellsVersion = null;

    public void wipe(class_3218 world, class_3222 player) {
        if (player.method_5687(2) || world.method_8503().method_3724()) {
            if (this.wipeScheduledPlayer == player) {
                this.runs.clear();
                this.method_80();
                world.method_18456().forEach(p -> {
                    MineCellsData.syncCurrentPlayerData(p, world);
                    MineCells.DIMENSION_GRAPH.saveStuckPlayer((class_3222)p);
                });
                this.wipeScheduledPlayer = null;
                player.method_43496((class_2561)class_2561.method_43471((String)"chat.minecells.wipe_success"));
            } else {
                this.wipeScheduledPlayer = player;
                player.method_43496((class_2561)class_2561.method_43471((String)"chat.minecells.wipe_try"));
            }
        }
    }

    public static MineCellsData fromNbt(class_2487 nbt) {
        MineCellsData data = new MineCellsData();
        if (nbt.method_10545("mineCellsVersion")) {
            data.lastMineCellsVersion = nbt.method_10558("mineCellsVersion");
        }
        FabricLoader.getInstance().getModContainer("minecells").ifPresent(mod -> {
            String fullVersion = mod.getMetadata().getVersion().getFriendlyString();
            data.mineCellsVersion = fullVersion.substring(0, fullVersion.lastIndexOf(46));
        });
        if (nbt.method_10545("runs")) {
            class_2487 entryNbt = nbt.method_10562("runs");
            for (String id : entryNbt.method_10541()) {
                data.runs.put(data.runs.size(), new RunData(entryNbt.method_10562(id), data));
            }
        }
        return data;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 entryNbt = new class_2487();
        for (Map.Entry<Integer, RunData> entry : this.runs.entrySet()) {
            entryNbt.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().writeNbt(new class_2487()));
        }
        nbt.method_10566("runs", (class_2520)entryNbt);
        if (this.mineCellsVersion != null) {
            nbt.method_10582("mineCellsVersion", this.mineCellsVersion);
        }
        return nbt;
    }

    public void wipeIfVersionMismatched(class_3218 world) {
        if (this.lastMineCellsVersion != null && this.mineCellsVersion != null && !this.mineCellsVersion.equals(this.lastMineCellsVersion) && MineCells.COMMON_CONFIG.autoWipeData) {
            MineCells.LOGGER.warn("Mine Cells version changed from " + this.lastMineCellsVersion + " to " + this.mineCellsVersion + "!");
            MineCells.LOGGER.warn("Mine Cells data will be wiped!");
            this.runs.clear();
            this.lastMineCellsVersion = this.mineCellsVersion;
            this.method_80();
            world.method_18456().forEach(p -> {
                MineCellsData.syncCurrentPlayerData(p, world);
                MineCells.DIMENSION_GRAPH.saveStuckPlayer((class_3222)p);
                if (p.method_5687(2) || world.method_8503().method_3724()) {
                    p.method_43496((class_2561)class_2561.method_43471((String)"chat.minecells.wipe_success"));
                }
            });
        }
    }

    public static MineCellsData get(class_3218 world) {
        return (MineCellsData)world.method_8503().method_30002().method_17983().method_17924(MineCellsData::fromNbt, MineCellsData::new, "MineCellsData");
    }

    public static PlayerData getPlayerData(class_3222 player, class_3218 world, class_2338 posOverride) {
        return MineCellsData.get(world).getRun(posOverride == null ? player.method_24515() : posOverride).getPlayerData((class_1657)player);
    }

    public RunData getRun(int x, int z) {
        for (Map.Entry<Integer, RunData> entry : this.runs.entrySet()) {
            if (entry.getValue().x != x || entry.getValue().z != z) continue;
            return entry.getValue();
        }
        RunData run = new RunData(x, z, this);
        this.runs.put(this.runs.size(), run);
        this.method_80();
        return run;
    }

    public RunData getRun(class_2338 pos) {
        return this.getRun(Math.round((float)pos.method_10263() / 1024.0f), Math.round((float)pos.method_10260() / 1024.0f));
    }

    public static void syncCurrentPlayerData(class_3222 player, class_3218 world) {
        PlayerSpecificMineCellsData data = new PlayerSpecificMineCellsData(MineCellsData.get(world), player);
        ((PlayerEntityAccessor)player).setMineCellsData(data);
        SyncMineCellsPlayerDataS2CPacket.send(player, data);
    }

    public static class RunData {
        public final int x;
        public final int z;
        private final class_18 parent;
        public final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

        public RunData(int x, int z, class_18 parent) {
            this.x = x;
            this.z = z;
            this.parent = parent;
        }

        public RunData(class_2487 nbt, class_18 parent) {
            this.x = nbt.method_10550("X");
            this.z = nbt.method_10550("Z");
            class_2487 playersNbt = nbt.method_10562("Players");
            for (String uuid : playersNbt.method_10541()) {
                this.players.put(UUID.fromString(uuid), new PlayerData(playersNbt.method_10562(uuid), parent));
            }
            this.parent = parent;
        }

        public class_2487 writeNbt(class_2487 nbt) {
            nbt.method_10569("X", this.x);
            nbt.method_10569("Z", this.z);
            class_2487 playersNbt = new class_2487();
            for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
                class_2487 compound = new class_2487();
                playersNbt.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().writeNbt(compound));
            }
            nbt.method_10566("Players", (class_2520)playersNbt);
            return nbt;
        }

        public PlayerData getPlayerData(class_1657 player) {
            if (this.players.containsKey(player.method_5667())) {
                return this.players.get(player.method_5667());
            }
            PlayerData playerData = new PlayerData(new class_2487(), this.parent);
            this.players.put(player.method_5667(), playerData);
            this.parent.method_80();
            return playerData;
        }
    }

    public static class PlayerData {
        public static final PlayerData EMPTY = new PlayerData(new class_2487(), null);
        public final Map<MineCellsDimension, List<class_2338>> activatedSpawnerRunes = new HashMap<MineCellsDimension, List<class_2338>>();
        public final List<PortalData> portals = new ArrayList<PortalData>();
        private final class_18 parent;

        public PlayerData(class_2487 nbt, class_18 parent) {
            this.parent = parent;
            class_2487 runeNbt = nbt.method_10562("ActivatedSpawnerRunes");
            for (String id : runeNbt.method_10541()) {
                MineCellsDimension dimension = MineCellsDimension.of(new class_2960(id));
                this.activatedSpawnerRunes.put(dimension, new ArrayList());
                for (long pos : runeNbt.method_10565(id)) {
                    this.activatedSpawnerRunes.get((Object)dimension).add(class_2338.method_10092((long)pos));
                }
            }
            class_2487 portalNbt = nbt.method_10562("Portals");
            for (String id : portalNbt.method_10541()) {
                this.portals.add(PortalData.fromNbt(portalNbt.method_10562(id)));
            }
        }

        public class_2487 writeNbt(class_2487 nbt) {
            class_2487 runeNbt = new class_2487();
            for (MineCellsDimension id : this.activatedSpawnerRunes.keySet()) {
                runeNbt.method_10564(id.key.method_29177().toString(), this.activatedSpawnerRunes.get((Object)id).stream().mapToLong(class_2338::method_10063).toArray());
            }
            nbt.method_10566("ActivatedSpawnerRunes", (class_2520)runeNbt);
            class_2487 portalNbt = new class_2487();
            int i = 0;
            for (PortalData portal : this.portals) {
                portalNbt.method_10566(String.valueOf(i), (class_2520)portal.writeNbt(new class_2487()));
                ++i;
            }
            nbt.method_10566("Portals", (class_2520)portalNbt);
            return nbt;
        }

        public void addActivatedSpawnerRune(MineCellsDimension dimension, class_2338 pos) {
            this.activatedSpawnerRunes.computeIfAbsent(dimension, k -> new ArrayList()).add(pos);
            if (this.parent != null) {
                this.parent.method_80();
            }
        }

        public boolean hasActivatedSpawnerRune(MineCellsDimension dimension, class_2338 pos) {
            return this.activatedSpawnerRunes.computeIfAbsent(dimension, k -> new ArrayList()).contains(pos);
        }

        public boolean hasVisitedDimension(MineCellsDimension dimension) {
            return this.portals.stream().anyMatch(it -> it.toDimension == dimension || it.fromDimension == dimension);
        }

        public void addPortalData(MineCellsDimension fromDimension, MineCellsDimension toDimension, class_2338 fromPos, class_2338 toPos) {
            this.portals.removeIf(data -> data.fromDimension == fromDimension && data.toDimension == toDimension || data.toDimension == toDimension && data.fromDimension == toDimension);
            this.portals.add(new PortalData(fromDimension, toDimension, fromPos, toPos));
            if (this.parent != null) {
                this.parent.method_80();
            }
        }

        public Optional<PortalData> getPortalData(MineCellsDimension fromDimension, MineCellsDimension toDimension) {
            Optional<PortalData> result = this.portals.stream().filter(it -> it.fromDimension == fromDimension && it.toDimension == toDimension).findFirst();
            if (result.isPresent()) {
                return result;
            }
            return this.portals.stream().filter(it -> it.fromDimension == toDimension && it.toDimension == fromDimension).findFirst().map(it -> new PortalData(it.toDimension, it.fromDimension, it.toPos, it.fromPos));
        }

        public record PortalData(MineCellsDimension fromDimension, MineCellsDimension toDimension, class_2338 fromPos, class_2338 toPos) {
            public static PortalData fromNbt(class_2487 nbt) {
                return new PortalData(MineCellsDimension.of(new class_2960(nbt.method_10558("FromDimension"))), MineCellsDimension.of(new class_2960(nbt.method_10558("ToDimension"))), class_2338.method_10092((long)nbt.method_10537("FromPos")), class_2338.method_10092((long)nbt.method_10537("ToPos")));
            }

            public class_2487 writeNbt(class_2487 nbt) {
                nbt.method_10582("FromDimension", this.fromDimension.key.method_29177().toString());
                nbt.method_10582("ToDimension", this.toDimension.key.method_29177().toString());
                nbt.method_10544("FromPos", this.fromPos.method_10063());
                nbt.method_10544("ToPos", this.toPos.method_10063());
                return nbt;
            }
        }
    }
}

