/*
 * Decompiled with CFR 0.152.
 */
package safro.archon.api;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import safro.archon.api.ManaAttributes;
import safro.archon.registry.ComponentsRegistry;
import safro.archon.registry.EffectRegistry;
import safro.archon.util.ArchonUtil;

public class ManaComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    private final class_1657 player;
    private int mana = 1;
    private int manaTickTimer;
    private int regenSpeed = 20;

    public ManaComponent(class_1657 player) {
        this.player = player;
    }

    public void serverTick() {
        if (this.getMana() < 0) {
            this.setMana(1);
        } else if (this.getMana() < this.getMaxMana()) {
            ++this.manaTickTimer;
            if (this.manaTickTimer >= this.getRegenSpeed()) {
                ++this.mana;
                this.manaTickTimer = 0;
                ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
            }
        } else {
            this.manaTickTimer = 0;
        }
    }

    public void readFromNbt(class_2487 nbt) {
        this.mana = nbt.method_10550("mana");
        this.manaTickTimer = nbt.method_10550("manaTickTimer");
        this.regenSpeed = nbt.method_10550("regenSpeed");
    }

    public void writeToNbt(class_2487 nbt) {
        nbt.method_10569("mana", this.mana);
        nbt.method_10569("manaTickTimer", this.manaTickTimer);
        nbt.method_10569("regenSpeed", this.regenSpeed);
    }

    public void setDefaultRegenSpeed() {
        int x = 20;
        if (ArchonUtil.getScroll(this.player) != null && ArchonUtil.getScroll(this.player).equals("accelerate")) {
            x = 10;
        }
        this.setRegenSpeed(x);
    }

    public boolean canUseMana(int amount) {
        if (this.player.method_6059(EffectRegistry.OBSTRUCTED)) {
            return false;
        }
        return this.getMana() >= amount;
    }

    public void clampMana() {
        if (this.getMana() > this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        }
    }

    public void addMana(int mana) {
        if (this.getMana() + mana > this.getMaxMana()) {
            this.setMana(this.getMaxMana());
        } else {
            this.mana += mana;
        }
        ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
    }

    public void removeMana(int mana) {
        this.mana -= mana;
        ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
    }

    public void setMana(int amount) {
        this.mana = amount;
        ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
    }

    public void setMaxMana(int amount) {
        this.player.method_5996((class_1320)ManaAttributes.MAX_MANA).method_6192((double)amount);
        this.clampMana();
        ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
    }

    public void setRegenSpeed(int amount) {
        if (amount < 0) {
            amount = 1;
        }
        this.regenSpeed = amount;
        ComponentsRegistry.MANA_COMPONENT.sync((Object)this.player);
    }

    public void removeMaxModifier(UUID id) {
        if (this.player.method_5996((class_1320)ManaAttributes.MAX_MANA).method_6199(id) != null) {
            this.player.method_5996((class_1320)ManaAttributes.MAX_MANA).method_6200(id);
        }
    }

    public void addMaxModifier(UUID id, String name, double amt, boolean temp) {
        class_1322 modifier = new class_1322(id, name, amt, class_1322.class_1323.field_6328);
        class_1324 instance = this.player.method_5996((class_1320)ManaAttributes.MAX_MANA);
        if (instance.method_6196(modifier)) {
            return;
        }
        if (temp) {
            instance.method_26835(modifier);
        } else {
            instance.method_26837(modifier);
        }
    }

    public int getMana() {
        return this.mana;
    }

    public int getMaxMana() {
        return (int)this.player.method_26825((class_1320)ManaAttributes.MAX_MANA);
    }

    public int getRegenSpeed() {
        return this.regenSpeed;
    }
}

