/*
 * Decompiled with CFR 0.152.
 */
package safro.archon.entity.boss;

import java.util.List;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBossEntity
extends class_1588 {
    private final class_3213 bossBar = new class_3213(this.method_5476(), this.getBossColor(), class_1259.class_1261.field_5795);
    private static final class_2940<Integer> INVUL_TIMER = class_2945.method_12791(AbstractBossEntity.class, (class_2941)class_2943.field_13327);

    public AbstractBossEntity(class_1299<? extends AbstractBossEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 50;
    }

    public abstract class_1259.class_1260 getBossColor();

    public abstract int getInvulTime();

    public abstract class_1792 getDrop();

    public abstract class_2561 getSpawnMessage();

    public abstract class_2561 getKillMessage();

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(INVUL_TIMER, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Invul", this.getInvulnerableTimer());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setInvulnerableTimer(nbt.method_10550("Invul"));
        if (this.method_16914()) {
            this.bossBar.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossBar.method_5413(this.method_5476());
    }

    public void onSummoned() {
        this.setInvulnerableTimer(this.getInvulTime());
        this.bossBar.method_5408(0.0f);
        this.sendMessage(this.getSpawnMessage(), 50.0);
    }

    public void sendMessage(class_2561 text, double radius) {
        List<class_1657> list = this.getPlayers(radius);
        while (list.iterator().hasNext()) {
            class_1657 player = list.iterator().next();
            player.method_7353(text, false);
            list.remove(player);
        }
    }

    protected List<class_1657> getPlayers(double radius) {
        return this.method_37908().method_18467(class_1657.class, this.method_5829().method_1014(radius));
    }

    public void pushEntity(class_1309 entity, float power) {
        class_243 vec = entity.method_18798();
        entity.method_18800((entity.method_23317() - this.method_23317()) * (double)power + vec.method_10216(), 0.2, (entity.method_23321() - this.method_23321()) * (double)power + vec.method_10215());
        entity.field_6037 = true;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public void method_6007() {
        super.method_6007();
        if (this.getInvulnerableTimer() > 0) {
            for (int d = 0; d < 3; ++d) {
                this.method_37908().method_8406((class_2394)class_2398.field_11226, this.method_23317() + this.field_5974.method_43059(), this.method_23318() + (double)(this.field_5974.method_43057() * 3.3f), this.method_23321() + this.field_5974.method_43059(), (double)0.7f, (double)0.7f, (double)0.9f);
            }
        }
    }

    protected void method_5958() {
        if (this.getInvulnerableTimer() > 0) {
            int i = this.getInvulnerableTimer() - 1;
            this.bossBar.method_5408(1.0f - (float)i / 220.0f);
            if (i <= 0) {
                this.onInvulComplete();
            }
            this.setInvulnerableTimer(i);
            if (this.field_6012 % 10 == 0) {
                this.method_6025(10.0f);
            }
        } else {
            super.method_5958();
            if (this.field_6012 % 20 == 0) {
                this.method_6025(1.0f);
            }
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
        }
    }

    protected void onInvulComplete() {
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source != this.method_37908().method_48963().method_48824()) {
            if (this.getInvulnerableTimer() > 0 && source != this.method_37908().method_48963().method_48829()) {
                return false;
            }
            return super.method_5643(source, amount);
        }
        return false;
    }

    public int getInvulnerableTimer() {
        return (Integer)this.field_6011.method_12789(INVUL_TIMER);
    }

    public void setInvulnerableTimer(int ticks) {
        this.field_6011.method_12778(INVUL_TIMER, (Object)ticks);
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        class_1542 itemEntity = this.method_5706((class_1935)this.getDrop());
        if (itemEntity != null) {
            itemEntity.method_6976();
        }
    }

    public boolean method_5874(class_3218 world, class_1309 other) {
        if (super.method_5874(world, other) && other instanceof class_1657) {
            this.sendMessage(this.getKillMessage(), 50.0);
            return true;
        }
        return false;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.method_31472();
        } else {
            this.field_6278 = 0;
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }
}

