/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.util;

import dev.emi.emi.api.stack.EmiIngredient;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class WidgetRowBuilder {
    private final int maxWidth;
    private final List<ClientBuiltPool> poolList = new LinkedList<ClientBuiltPool>();
    private int width = 0;

    public WidgetRowBuilder(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public List<ClientBuiltPool> getPoolList() {
        return this.poolList;
    }

    public int getWidth() {
        return this.width;
    }

    private boolean add(ClientBuiltPool newPool) {
        int newWidth = this.getNewWidth(newPool);
        if (this.width + newWidth > this.maxWidth) {
            return false;
        }
        this.width += newWidth;
        this.poolList.add(newPool);
        return true;
    }

    public Optional<ClientBuiltPool> addAndTrim(ClientBuiltPool newPool) {
        if (this.add(newPool)) {
            return Optional.empty();
        }
        if (this.width == 0) {
            Float2ObjectArrayMap madeItIn = new Float2ObjectArrayMap();
            Float2ObjectArrayMap leftOvers = new Float2ObjectArrayMap();
            AtomicInteger newWidth = new AtomicInteger(14 + 11 * ((newPool.list().size() - 1) / 2 - 1));
            newPool.stackMap().forEach((arg_0, arg_1) -> this.lambda$addAndTrim$0(newWidth, (Float2ObjectMap)madeItIn, (Float2ObjectMap)leftOvers, arg_0, arg_1));
            this.add(new ClientBuiltPool(newPool.list(), (Float2ObjectMap<EmiIngredient>)madeItIn));
            return Optional.of(new ClientBuiltPool(newPool.list(), (Float2ObjectMap<EmiIngredient>)leftOvers));
        }
        return Optional.of(newPool);
    }

    private int getNewWidth(ClientBuiltPool newPool) {
        int newWidth = this.poolList.isEmpty() ? 14 + 11 * ((newPool.list().size() - 1) / 2) + 20 * newPool.stackMap().size() : 20 + 11 * ((newPool.list().size() - 1) / 2) + 20 * newPool.stackMap().size();
        return newWidth;
    }

    public boolean canAddPool(ClientBuiltPool newPool) {
        int newWidth = this.getNewWidth(newPool);
        return this.width + newWidth <= this.maxWidth;
    }

    public boolean canAddOther(WidgetRowBuilder other) {
        return this.width + other.width + 6 <= this.maxWidth;
    }

    public void addOther(WidgetRowBuilder other) {
        this.poolList.addAll(other.poolList);
    }

    public static void collate(List<WidgetRowBuilder> builders) {
        if (builders.isEmpty()) {
            return;
        }
        Int2IntOpenHashMap collateMap = new Int2IntOpenHashMap();
        for (int i = 0; i < builders.size(); ++i) {
            for (int j = 0; j < builders.size(); ++j) {
                if (i == j || !builders.get(j).canAddOther(builders.get(i))) continue;
                collateMap.put(j, i);
            }
        }
        if (!collateMap.isEmpty()) {
            Int2IntMap.Entry entry = (Int2IntMap.Entry)collateMap.int2IntEntrySet().stream().toList().get(0);
        }
    }

    private /* synthetic */ void lambda$addAndTrim$0(AtomicInteger newWidth, Float2ObjectMap madeItIn, Float2ObjectMap leftOvers, Float weight, EmiIngredient stacks) {
        if (newWidth.addAndGet(20) <= this.maxWidth) {
            madeItIn.put(weight.floatValue(), (Object)stacks);
        } else {
            leftOvers.put(weight.floatValue(), (Object)stacks);
        }
    }
}

