/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.block;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import satisfyu.beachparty.networking.BeachpartyMessages;
import satisfyu.beachparty.registry.SoundEventRegistry;
import satisfyu.beachparty.util.BeachpartyUtil;

public class RadioBlock
extends class_2248 {
    public static final class_2746 ON;
    public static final class_2758 CHANNEL;
    public static final class_2753 FACING;
    public static final class_2746 SEARCHING;
    public static final int CHANNELS;
    public static final int DELAY = 40;
    private static final Supplier<class_265> voxelShapeSupplier;
    public static final Map<class_2350, class_265> SHAPE;

    public RadioBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ON, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CHANNEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)SEARCHING, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE.get(state.method_11654((class_2769)FACING));
    }

    public class_2680 method_9605(class_1750 context) {
        int channel = class_5819.method_43047().method_39332(0, CHANNELS - 1);
        class_2350 facing = class_2350.field_11043;
        if (context.method_8042().method_10166() != class_2350.class_2351.field_11052) {
            facing = context.method_8042().method_10153();
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)CHANNEL, (Comparable)Integer.valueOf(channel));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (((Boolean)state.method_11654((class_2769)SEARCHING)).booleanValue()) {
            return class_1269.field_21466;
        }
        if (hand == class_1268.field_5808) {
            boolean newState;
            boolean bl = newState = (Boolean)state.method_11654((class_2769)ON) == false;
            if (newState) {
                this.turnON(state, world, pos, player);
                RadioBlock.spawnParticles(world, pos);
            } else {
                this.turnOFF(state, world, pos, player);
            }
            if (!world.field_9236) {
                if (newState) {
                    for (int i = 0; i < 5; ++i) {
                        double x = (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5;
                        double y = (double)pos.method_10264() + 0.5 + world.field_9229.method_43058() * 0.5;
                        double z = (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5;
                        world.method_8406((class_2394)class_2398.field_11224, x, y, z, 0.0, 0.0, 0.0);
                        world.method_8406((class_2394)class_2398.field_11224, x, y, z, 0.1, 0.0, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    private void turnON(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396(player, pos, (class_3414)SoundEventRegistry.RADIO_CLICK.get(), class_3419.field_15245, 1.0f, 1.0f);
        world.method_8396(player, pos, (class_3414)SoundEventRegistry.RADIO_TUNE.get(), class_3419.field_15247, 0.8f, 1.0f);
        if (!world.field_9236) {
            this.pressButton(state, world, pos, true);
            this.sendPacket(state, (class_3218)world, pos, true);
        }
    }

    private void turnOFF(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396(player, pos, (class_3414)SoundEventRegistry.RADIO_CLICK.get(), class_3419.field_15245, 1.0f, 1.0f);
        if (!world.field_9236) {
            this.pressButton(state, world, pos, false);
            this.sendPacket(state, (class_3218)world, pos, false);
        }
    }

    public int tune(class_1937 world, class_2680 blockState, class_2338 blockPos, int scrollValue) {
        if (scrollValue % CHANNELS == 0) {
            return (Integer)blockState.method_11654((class_2769)CHANNEL);
        }
        int currentChannel = (Integer)blockState.method_11654((class_2769)CHANNEL);
        int newChannel = scrollValue < 0 ? (CHANNELS - Math.abs(currentChannel + scrollValue) % CHANNELS) % CHANNELS : (currentChannel + scrollValue) % CHANNELS;
        world.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)CHANNEL, (Comparable)Integer.valueOf(newChannel))).method_11657((class_2769)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        world.method_39279(blockPos, (class_2248)this, 40);
        return newChannel;
    }

    private void pressButton(class_2680 state, class_1937 world, class_2338 pos, boolean on) {
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)ON, (Comparable)Boolean.valueOf(on))).method_11657((class_2769)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        world.method_39279(pos, (class_2248)this, 40);
    }

    private void sendPacket(class_2680 state, class_3218 world, class_2338 pos, boolean on) {
        for (class_3222 player : world.method_18456()) {
            class_2540 buffer = BeachpartyUtil.createPacketBuf();
            buffer.method_10807(pos);
            buffer.writeInt(((Integer)state.method_11654((class_2769)CHANNEL)).intValue());
            buffer.writeBoolean(on);
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)BeachpartyMessages.TURN_RADIO_S2C, (class_2540)buffer);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            if (!world.field_9236) {
                this.sendPacket(state, (class_3218)world, pos, false);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)SEARCHING)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SEARCHING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)ON)).booleanValue()) {
            RadioBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(class_1937 world, class_2338 pos) {
        class_5819 random = world.field_9229;
        double d = (double)pos.method_10263() + random.method_43058();
        double e = (double)pos.method_10264() + 0.5 + random.method_43058();
        double f = (double)pos.method_10260() + random.method_43058();
        world.method_8406((class_2394)class_2398.field_11224, d, e, f, 0.0, 0.0, 0.0);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, ON, CHANNEL, SEARCHING});
    }

    public void method_9568(class_1799 itemStack, class_1922 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.beachparty.canbeplaced").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.beachparty.radioturnon").method_27692(class_124.field_1068));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.beachparty.radioswitch").method_27692(class_124.field_1068));
    }

    static {
        FACING = class_2383.field_11177;
        CHANNELS = SoundEventRegistry.RADIO_SOUNDS.size();
        voxelShapeSupplier = () -> class_259.method_1081((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.6875);
        SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
            for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
            }
        });
        ON = class_2746.method_11825((String)"on");
        CHANNEL = class_2758.method_11867((String)"channel", (int)0, (int)(CHANNELS - 1));
        SEARCHING = class_2746.method_11825((String)"searching");
    }
}

