/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_836;
import net.minecraft.class_918;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtils;

public class ItemArmorGeoLayer<T extends class_1309>
extends GeoRenderLayer<T> {
    protected static final Map<String, class_2960> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();
    protected static final class_572<class_1309> INNER_ARMOR_MODEL = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
    protected static final class_572<class_1309> OUTER_ARMOR_MODEL = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27580));
    @Nullable
    protected class_1799 mainHandStack;
    @Nullable
    protected class_1799 offhandStack;
    @Nullable
    protected class_1799 helmetStack;
    @Nullable
    protected class_1799 chestplateStack;
    @Nullable
    protected class_1799 leggingsStack;
    @Nullable
    protected class_1799 bootsStack;

    public ItemArmorGeoLayer(GeoRenderer<T> geoRenderer) {
        super(geoRenderer);
    }

    @Nonnull
    protected class_1304 getEquipmentSlotForBone(GeoBone bone, class_1799 stack, T animatable) {
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178 || stack != animatable.method_6118(slot)) continue;
            return slot;
        }
        return class_1304.field_6174;
    }

    @Nonnull
    protected class_630 getModelPartForBone(GeoBone bone, class_1304 slot, class_1799 stack, T animatable, class_572<?> baseModel) {
        return baseModel.field_3391;
    }

    @Nullable
    protected class_1799 getArmorItemForBone(GeoBone bone, T animatable) {
        return null;
    }

    @Override
    public void preRender(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        this.mainHandStack = animatable.method_6118(class_1304.field_6173);
        this.offhandStack = animatable.method_6118(class_1304.field_6171);
        this.helmetStack = animatable.method_6118(class_1304.field_6169);
        this.chestplateStack = animatable.method_6118(class_1304.field_6174);
        this.leggingsStack = animatable.method_6118(class_1304.field_6172);
        this.bootsStack = animatable.method_6118(class_1304.field_6166);
    }

    @Override
    public void renderForBone(class_4587 poseStack, T animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        class_1747 blockItem;
        class_1799 armorStack = this.getArmorItemForBone(bone, animatable);
        if (armorStack == null) {
            return;
        }
        class_1792 class_17922 = armorStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            this.renderSkullAsArmor(poseStack, bone, armorStack, skullBlock, bufferSource, packedLight);
        } else {
            class_1304 slot = this.getEquipmentSlotForBone(bone, armorStack, animatable);
            class_572<?> model = this.getModelForItem(bone, slot, armorStack, animatable);
            class_630 modelPart = this.getModelPartForBone(bone, slot, armorStack, animatable, model);
            if (!modelPart.field_3663.isEmpty()) {
                poseStack.method_22903();
                poseStack.method_22905(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.prepForRender((class_1297)animatable, armorStack, slot, model);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.method_2828(poseStack, null, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (armorStack.method_7909() instanceof class_1738) {
                    this.prepModelPartForRender(poseStack, bone, modelPart);
                    this.renderVanillaArmorPiece(poseStack, animatable, bone, slot, armorStack, modelPart, bufferSource, partialTick, packedLight, packedOverlay);
                }
                poseStack.method_22909();
            }
        }
        buffer = bufferSource.getBuffer(renderType);
    }

    protected <I extends class_1792> void renderVanillaArmorPiece(class_4587 poseStack, T animatable, GeoBone bone, class_1304 slot, class_1799 armorStack, class_630 modelPart, class_4597 bufferSource, float partialTick, int packedLight, int packedOverlay) {
        class_2960 texture = this.getVanillaArmorResource((class_1297)animatable, armorStack, slot, "");
        class_4588 buffer = this.getArmorBuffer(bufferSource, null, texture, armorStack.method_7958());
        class_1792 class_17922 = armorStack.method_7909();
        if (class_17922 instanceof class_4057) {
            class_4057 dyable = (class_4057)class_17922;
            int color = dyable.method_7800(armorStack);
            modelPart.method_22699(poseStack, buffer, packedLight, packedOverlay, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
            texture = this.getVanillaArmorResource((class_1297)animatable, armorStack, slot, "overlay");
            buffer = this.getArmorBuffer(bufferSource, null, texture, false);
        }
        modelPart.method_22699(poseStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected class_4588 getArmorBuffer(class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_2960 texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = class_1921.method_25448((class_2960)texturePath);
        }
        return class_918.method_27952((class_4597)bufferSource, (class_1921)renderType, (boolean)false, (boolean)enchanted);
    }

    @Nonnull
    protected class_572<?> getModelForItem(GeoBone bone, class_1304 slot, class_1799 stack, T animatable) {
        class_572<class_1309> defaultModel = slot == class_1304.field_6172 ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        return RenderProvider.of(stack).getHumanoidArmorModel(null, stack, null, defaultModel);
    }

    public class_2960 getVanillaArmorResource(class_1297 entity, class_1799 stack, class_1304 slot, String type) {
        String domain = "minecraft";
        String path = ((class_1738)stack.method_7909()).method_7686().method_7694();
        String[] materialNameSplit = path.split(":", 2);
        if (materialNameSplit.length > 1) {
            domain = materialNameSplit[0];
            path = materialNameSplit[1];
        }
        if (!((String)type).isBlank()) {
            type = "_" + (String)type;
        }
        String texture = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, path, slot == class_1304.field_6172 ? 2 : 1, type);
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, class_2960::new);
    }

    protected void renderSkullAsArmor(class_4587 poseStack, GeoBone bone, class_1799 stack, class_2190 skullBlock, class_4597 bufferSource, int packedLight) {
        GameProfile skullProfile = null;
        class_2487 stackTag = stack.method_7969();
        if (stackTag != null) {
            class_2519 tag;
            String skullOwner;
            class_2520 skullTag = stackTag.method_10580("SkullOwner");
            if (skullTag instanceof class_2487) {
                class_2487 compoundTag = (class_2487)skullTag;
                skullProfile = class_2512.method_10683((class_2487)compoundTag);
            } else if (skullTag instanceof class_2519 && !(skullOwner = (tag = (class_2519)skullTag).method_10714()).isBlank()) {
                class_2487 profileTag = new class_2487();
                class_2631.method_11335((GameProfile)new GameProfile(null, skullOwner), name -> stackTag.method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)profileTag, (GameProfile)name)));
                skullProfile = class_2512.method_10683((class_2487)profileTag);
            }
        }
        class_2484.class_2485 type = skullBlock.method_9327();
        class_5598 model = (class_5598)class_836.method_32160((class_5599)class_310.method_1551().method_31974()).get(type);
        class_1921 renderType = class_836.method_3578((class_2484.class_2485)type, (GameProfile)skullProfile);
        poseStack.method_22903();
        RenderUtils.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.method_22905(1.1875f, 1.1875f, 1.1875f);
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)poseStack, (class_4597)bufferSource, (int)packedLight, (class_5598)model, (class_1921)renderType);
        poseStack.method_22909();
    }

    protected void prepModelPartForRender(class_4587 poseStack, GeoBone bone, class_630 sourcePart) {
        GeoCube firstCube = bone.getCubes().get(0);
        class_630.class_628 armorCube = (class_630.class_628)sourcePart.field_3663.get(0);
        double armorBoneSizeX = firstCube.size().method_10216();
        double armorBoneSizeY = firstCube.size().method_10214();
        double armorBoneSizeZ = firstCube.size().method_10215();
        double actualArmorSizeX = Math.abs(armorCube.field_3648 - armorCube.field_3645);
        double actualArmorSizeY = Math.abs(armorCube.field_3647 - armorCube.field_3644);
        double actualArmorSizeZ = Math.abs(armorCube.field_3646 - armorCube.field_3643);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.method_2851(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_3654 = -bone.getRotX();
        sourcePart.field_3675 = -bone.getRotY();
        sourcePart.field_3674 = bone.getRotZ();
        poseStack.method_22905(scaleX, scaleY, scaleZ);
    }
}

